/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.CategoryOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.CategoryDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.spi.search.CategorySearchResult;
import org.n52.series.spi.search.SearchResult;
import org.n52.web.exception.ResourceNotFoundException;

public class CategoryRepository
extends SessionAwareRepository
implements OutputAssembler<CategoryOutput> {
    private CategoryDao createDao(Session session) {
        return new CategoryDao(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            CategoryDao dao = this.createDao(session);
            boolean bl = dao.hasInstance(this.parseId(id), parameters, CategoryEntity.class);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        Session session = this.getSession();
        try {
            CategoryDao categoryDao = this.createDao(session);
            DbQuery query = this.getDbQuery(parameters);
            List<CategoryEntity> found = categoryDao.find(query);
            List<SearchResult> list = this.convertToSearchResults(found, query);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<SearchResult> convertToSearchResults(List<? extends DescribableEntity> found, DbQuery query) {
        String locale = query.getLocale();
        String hrefBase = this.urlHelper.getProceduresHrefBaseUrl(query.getHrefBase());
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (DescribableEntity describableEntity : found) {
            String pkid = describableEntity.getPkid().toString();
            String label = describableEntity.getLabelFrom(locale);
            results.add((SearchResult)new CategorySearchResult(pkid, label, hrefBase));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CategoryOutput> getAllCondensed(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<CategoryOutput> list = this.getAllCondensed(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<CategoryOutput> getAllCondensed(DbQuery parameters, Session session) throws DataAccessException {
        ArrayList<CategoryOutput> results = new ArrayList<CategoryOutput>();
        for (CategoryEntity categoryEntity : this.getAllInstances(parameters, session)) {
            results.add(this.createCondensed(categoryEntity, parameters));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CategoryOutput> getAllExpanded(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<CategoryOutput> list = this.getAllExpanded(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<CategoryOutput> getAllExpanded(DbQuery parameters, Session session) throws DataAccessException {
        ArrayList<CategoryOutput> results = new ArrayList<CategoryOutput>();
        for (CategoryEntity categoryEntity : this.getAllInstances(parameters, session)) {
            results.add(this.createExpanded(categoryEntity, parameters));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CategoryOutput getInstance(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            CategoryOutput categoryOutput = this.getInstance(id, parameters, session);
            return categoryOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public CategoryOutput getInstance(String id, DbQuery parameters, Session session) throws DataAccessException {
        CategoryEntity entity = this.getInstance(this.parseId(id), parameters, session);
        return this.createExpanded(entity, parameters);
    }

    protected CategoryEntity getInstance(Long id, DbQuery parameters, Session session) throws DataAccessException {
        CategoryDao categoryDao = this.createDao(session);
        CategoryEntity result = (CategoryEntity)categoryDao.getInstance(id, parameters);
        if (result == null) {
            throw new ResourceNotFoundException("Resource with id '" + id + "' could not be found.");
        }
        return result;
    }

    protected List<CategoryEntity> getAllInstances(DbQuery parameters, Session session) throws DataAccessException {
        return this.createDao(session).getAllInstances(parameters);
    }

    protected CategoryOutput createExpanded(CategoryEntity entity, DbQuery parameters) throws DataAccessException {
        CategoryOutput result = this.createCondensed(entity, parameters);
        if (parameters.getHrefBase() != null) {
            result.setService(this.getCondensedExtendedService(this.getServiceEntity(entity), parameters));
        } else {
            result.setService(this.getCondensedService(entity.getService(), parameters));
        }
        return result;
    }

    protected CategoryOutput createCondensed(CategoryEntity entity, DbQuery parameters) {
        CategoryOutput result = new CategoryOutput();
        result.setId(Long.toString(entity.getPkid()));
        result.setLabel(entity.getLabelFrom(parameters.getLocale()));
        result.setDomainId(entity.getDomainId());
        this.checkForHref(result, parameters);
        return result;
    }

    private void checkForHref(CategoryOutput result, DbQuery parameters) {
        if (parameters.getHrefBase() != null) {
            result.setHrefBase(this.urlHelper.getCategoriesHrefBaseUrl(parameters.getHrefBase()));
        }
    }
}

