/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.DatasetFactoryException;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.PlatformOutput;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.SeriesParameters;
import org.n52.io.response.dataset.ValueType;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.IDataRepositoryFactory;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.PlatformRepository;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.spi.search.DatasetSearchResult;
import org.n52.series.spi.search.SearchResult;
import org.n52.web.exception.BadQueryParameterException;
import org.n52.web.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DatasetRepository<T extends Data>
extends SessionAwareRepository
implements OutputAssembler<DatasetOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetRepository.class);
    @Autowired
    private IDataRepositoryFactory dataRepositoryFactory;
    @Autowired
    private PlatformRepository platformRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            String dbId = ValueType.extractId((String)id);
            String handleAsFallback = parameters.getHandleAsValueTypeFallback();
            String valueType = ValueType.extractType((String)id, (String)handleAsFallback);
            if (!this.dataRepositoryFactory.isKnown(valueType)) {
                boolean bl = false;
                return bl;
            }
            DataRepository dataRepository = this.dataRepositoryFactory.create(valueType);
            DatasetDao<DatasetEntity> dao = this.getSeriesDao(valueType, session);
            Class datasetEntityType = dataRepository.getDatasetEntityType();
            boolean bl = parameters.getParameters().isMatchDomainIds() ? dao.hasInstance(dbId, parameters, datasetEntityType) : dao.hasInstance(this.parseId(dbId), parameters, datasetEntityType);
            return bl;
        }
        catch (DatasetFactoryException ex) {
            this.throwNewCreateFactoryException(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DatasetOutput> getAllCondensed(DbQuery query) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<DatasetOutput> list = this.getAllCondensed(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<DatasetOutput> getAllCondensed(DbQuery query, Session session) throws DataAccessException {
        ArrayList<DatasetOutput> results = new ArrayList<DatasetOutput>();
        FilterResolver filterResolver = query.getFilterResolver();
        if (query.getParameters().isMatchDomainIds()) {
            String valueType = query.getHandleAsValueTypeFallback();
            this.addCondensedResults(this.getSeriesDao(valueType, session), query, results, session);
            return results;
        }
        if (filterResolver.shallIncludeAllDatasetTypes()) {
            this.addCondensedResults(this.getSeriesDao(DatasetEntity.class, session), query, results, session);
        } else {
            for (String valueType : query.getDatasetTypes()) {
                this.addCondensedResults(this.getSeriesDao(valueType, session), query, results, session);
            }
        }
        return results;
    }

    private void addCondensedResults(DatasetDao<? extends DatasetEntity> dao, DbQuery query, List<DatasetOutput> results, Session session) throws DataAccessException {
        for (DatasetEntity datasetEntity : dao.getAllInstances(query)) {
            results.add(this.createCondensed(datasetEntity, query, session));
        }
    }

    private DatasetDao<? extends DatasetEntity> getSeriesDao(String valueType, Session session) throws DataAccessException {
        if (!"all".equalsIgnoreCase(valueType) && !this.dataRepositoryFactory.isKnown(valueType)) {
            throw new BadQueryParameterException("invalid type: " + valueType);
        }
        return this.createDataAccessRepository(valueType, session);
    }

    private DatasetDao<? extends DatasetEntity> getSeriesDao(String datasetId, DbQuery query, Session session) throws DataAccessException {
        String handleAsFallback = query.getHandleAsValueTypeFallback();
        String valueType = ValueType.extractType((String)datasetId, (String)handleAsFallback);
        if (!this.dataRepositoryFactory.isKnown(valueType)) {
            throw new ResourceNotFoundException("unknown type: " + valueType);
        }
        return this.createDataAccessRepository(valueType, session);
    }

    private DatasetDao<? extends DatasetEntity> createDataAccessRepository(String valueType, Session session) throws DataAccessException {
        try {
            DataRepository dataRepository = this.dataRepositoryFactory.create(valueType);
            return this.getSeriesDao(dataRepository.getDatasetEntityType(), session);
        }
        catch (DatasetFactoryException e) {
            throw new DataAccessException(e.getMessage());
        }
    }

    private DatasetDao<? extends DatasetEntity> getSeriesDao(Class<? extends DatasetEntity> clazz, Session session) {
        return new DatasetDao<DatasetEntity>(session, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DatasetOutput> getAllExpanded(DbQuery query) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<DatasetOutput> list = this.getAllExpanded(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<DatasetOutput> getAllExpanded(DbQuery query, Session session) throws DataAccessException {
        ArrayList<DatasetOutput> results = new ArrayList<DatasetOutput>();
        FilterResolver filterResolver = query.getFilterResolver();
        if (query.getParameters().isMatchDomainIds()) {
            String valueType = query.getHandleAsValueTypeFallback();
            this.addExpandedResults(this.getSeriesDao(valueType, session), query, results, session);
            return results;
        }
        if (filterResolver.shallIncludeAllDatasetTypes()) {
            this.addExpandedResults(this.getSeriesDao(DatasetEntity.class, session), query, results, session);
        } else {
            for (String valueType : query.getDatasetTypes()) {
                this.addExpandedResults(this.getSeriesDao(valueType, session), query, results, session);
            }
        }
        return results;
    }

    private void addExpandedResults(DatasetDao<? extends DatasetEntity> dao, DbQuery query, List<DatasetOutput> results, Session session) throws DataAccessException {
        for (DatasetEntity datasetEntity : dao.getAllInstances(query)) {
            results.add(this.createExpanded(datasetEntity, query, session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetOutput getInstance(String id, DbQuery query) throws DataAccessException {
        Session session = this.getSession();
        try {
            DatasetOutput datasetOutput = this.getInstance(id, query, session);
            return datasetOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public DatasetOutput getInstance(String id, DbQuery query, Session session) throws DataAccessException {
        DatasetEntity<?> instanceEntity = this.getInstanceEntity(id, query, session);
        return this.createExpanded(instanceEntity, query, session);
    }

    DatasetEntity<?> getInstanceEntity(String id, DbQuery query, Session session) throws DataAccessException {
        String datasetId = ValueType.extractId((String)id);
        DatasetDao<DatasetEntity> dao = this.getSeriesDao(id, query, session);
        DatasetEntity instance = (DatasetEntity)dao.getInstance(Long.parseLong(datasetId), query);
        instance.setPlatform(this.platformRepository.getPlatformEntity(instance, query, session));
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters paramters) {
        Session session = this.getSession();
        try {
            DatasetDao<DatasetEntity> dao = this.getSeriesDao(DatasetEntity.class, session);
            DbQuery query = this.getDbQuery(paramters);
            List<DatasetEntity> found = dao.find(query);
            List<SearchResult> list = this.convertToSearchResults(found, query);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<SearchResult> convertToSearchResults(List<? extends DescribableEntity> found, DbQuery query) {
        String locale = query.getLocale();
        String hrefBase = this.urlHelper.getDatasetsHrefBaseUrl(query.getHrefBase());
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (DescribableEntity describableEntity : found) {
            String pkid = describableEntity.getPkid().toString();
            String label = describableEntity.getLabelFrom(locale);
            results.add((SearchResult)new DatasetSearchResult(pkid, label, hrefBase));
        }
        return results;
    }

    protected DatasetOutput createCondensed(DatasetEntity<?> series, DbQuery query, Session session) throws DataAccessException {
        DatasetOutput output = new DatasetOutput(series.getValueType()){};
        output.setLabel(this.createSeriesLabel(series, query.getLocale()));
        output.setId(series.getPkid().toString());
        output.setDomainId(series.getDomainId());
        output.setHrefBase(this.urlHelper.getDatasetsHrefBaseUrl(query.getHrefBase()));
        PlatformOutput platform = this.getCondensedPlatform(series, query, session);
        output.setPlatformType(platform.getPlatformType());
        return output;
    }

    protected DatasetOutput createExpanded(DatasetEntity<?> series, DbQuery query, Session session) throws DataAccessException {
        try {
            DatasetOutput result = this.createCondensed(series, query, session);
            SeriesParameters seriesParameters = this.createSeriesParameters(series, query, session);
            seriesParameters.setPlatform((ParameterOutput)this.getCondensedPlatform(series, query, session));
            result.setSeriesParameters(seriesParameters);
            if (series.getService() == null) {
                series.setService(this.getServiceEntity());
            }
            result.setUom(series.getUnitI18nName(query.getLocale()));
            DataRepository dataRepository = this.dataRepositoryFactory.create(series.getValueType());
            result.setFirstValue(dataRepository.getFirstValue(series, session, query));
            result.setLastValue(dataRepository.getLastValue(series, session, query));
            return result;
        }
        catch (DatasetFactoryException ex) {
            this.throwNewCreateFactoryException(ex);
            return null;
        }
    }

    private PlatformOutput getCondensedPlatform(DatasetEntity<?> series, DbQuery query, Session session) throws DataAccessException {
        return this.platformRepository.getCondensedInstance(series, query, session);
    }

    private String createSeriesLabel(DatasetEntity<?> series, String locale) {
        String station = series.getFeature().getLabelFrom(locale);
        String procedure = series.getProcedure().getLabelFrom(locale);
        String phenomenon = series.getPhenomenon().getLabelFrom(locale);
        String offering = series.getOffering().getLabelFrom(locale);
        StringBuilder sb = new StringBuilder();
        sb.append(phenomenon).append(" ");
        sb.append(procedure).append(", ");
        sb.append(station).append(", ");
        return sb.append(offering).toString();
    }

    public IDataRepositoryFactory getDataRepositoryFactory() {
        return this.dataRepositoryFactory;
    }

    public void setDataRepositoryFactory(IDataRepositoryFactory dataRepositoryFactory) {
        this.dataRepositoryFactory = dataRepositoryFactory;
    }

    private void throwNewCreateFactoryException(DatasetFactoryException e) throws DataAccessException {
        throw new DataAccessException("Could not create dataset factory.", e);
    }
}

