/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.HibernateSessionStore;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.dao.CategoryDao;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.DbQueryFactory;
import org.n52.series.db.dao.FeatureDao;
import org.n52.series.db.dao.PhenomenonDao;
import org.n52.series.db.dao.PlatformDao;
import org.n52.series.db.dao.ProcedureDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityCounter {
    @Autowired
    private HibernateSessionStore sessionStore;
    @Autowired
    private DbQueryFactory dbQueryFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countFeatures(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Integer n = new FeatureDao(session).getCount(query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    public Integer countOfferings(DbQuery query) throws DataAccessException {
        return this.countProcedures(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countProcedures(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Integer n = new ProcedureDao(session).getCount(query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countPhenomena(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Integer n = new PhenomenonDao(session).getCount(query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countCategories(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Integer n = new CategoryDao(session).getCount(query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countPlatforms(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Integer n = new PlatformDao(session).getCount(query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countDatasets(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Integer n = new DatasetDao<DatasetEntity>(session, DatasetEntity.class).getCount(query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countStations() throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            DbQuery query = this.createBackwardsCompatibleQuery();
            Integer n = this.countFeatures(query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countTimeseries() throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            DbQuery query = this.createBackwardsCompatibleQuery();
            Integer n = this.countDatasets(query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    private DbQuery createBackwardsCompatibleQuery() {
        return this.dbQueryFactory.createFrom(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"stationary", "insitu"}).extendWith("valueTypes", new String[]{"quantity"}));
    }
}

