/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;
import org.n52.io.response.GeometryInfo;
import org.n52.io.response.GeometryType;
import org.n52.io.response.PlatformOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataModelUtil;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.PlatformRepository;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.FeatureDao;
import org.n52.series.db.dao.SamplingGeometryDao;
import org.n52.series.spi.search.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GeometriesRepository
extends SessionAwareRepository
implements OutputAssembler<GeometryInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometriesRepository.class);
    private static final String NAMED_QUERY_GET_SAMPLING_GEOMETRIES_FOR_FEATURE = "getSampleLatLonGeometries";
    private static final String NAMED_QUERY_PARAMETER_FEATURE_ID = "featureid";
    @Autowired
    private PlatformRepository platformRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            if (GeometryType.isPlatformGeometryId((String)id)) {
                String dbId = GeometryType.extractId((String)id);
                FeatureDao dao = new FeatureDao(session);
                boolean bl = dao.hasInstance(this.parseId(dbId), parameters, FeatureEntity.class);
                return bl;
            }
            if (GeometryType.isObservedGeometryId((String)id)) {
                LOGGER.warn("ObservedGeometries not fully supported right now!");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeometryInfo> getAllCondensed(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<GeometryInfo> list = this.getAllCondensed(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<GeometryInfo> getAllCondensed(DbQuery parameters, Session session) throws DataAccessException {
        return this.getAllInstances(parameters, session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeometryInfo> getAllExpanded(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<GeometryInfo> list = this.getAllExpanded(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<GeometryInfo> getAllExpanded(DbQuery parameters, Session session) throws DataAccessException {
        return this.getAllInstances(parameters, session, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeometryInfo getInstance(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            GeometryInfo geometryInfo = this.getInstance(id, parameters, session);
            return geometryInfo;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public GeometryInfo getInstance(String id, DbQuery parameters, Session session) throws DataAccessException {
        parameters.setDatabaseAuthorityCode(this.getDatabaseSrid());
        if (GeometryType.isPlatformGeometryId((String)id)) {
            return this.getPlatformLocationGeometry(id, parameters, session);
        }
        return null;
    }

    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        return Collections.emptyList();
    }

    @Override
    public List<SearchResult> convertToSearchResults(List<? extends DescribableEntity> found, DbQuery query) {
        return Collections.emptyList();
    }

    private List<GeometryInfo> getAllInstances(DbQuery query, Session session, boolean expanded) throws DataAccessException {
        ArrayList<GeometryInfo> geometries = new ArrayList<GeometryInfo>();
        query.setDatabaseAuthorityCode(this.getDatabaseSrid());
        FilterResolver filterResolver = query.getFilterResolver();
        if (filterResolver.shallIncludeInsituPlatformTypes()) {
            if (filterResolver.shallIncludePlatformGeometriesSite()) {
                geometries.addAll(this.getAllSites(query, session, expanded));
            }
            if (filterResolver.shallIncludePlatformGeometriesTrack()) {
                geometries.addAll(this.getAllTracks(query, session, expanded));
            }
        }
        if (filterResolver.shallIncludeRemotePlatformTypes()) {
            if (filterResolver.shallIncludeObservedGeometriesStatic()) {
                geometries.addAll(this.getAllObservedGeometriesStatic(query, session, expanded));
            }
            if (filterResolver.shallIncludeObservedGeometriesDynamic()) {
                geometries.addAll(this.getAllObservedGeometriesDynamic(query, session, expanded));
            }
        }
        return geometries;
    }

    private GeometryInfo getPlatformLocationGeometry(String id, DbQuery parameters, Session session) throws DataAccessException {
        String geometryId = GeometryType.extractId((String)id);
        FeatureEntity featureEntity = this.getFeatureEntity(geometryId, parameters, session);
        if (featureEntity != null) {
            if (GeometryType.isSiteId((String)id)) {
                return this.createSite(featureEntity, parameters, true);
            }
            if (GeometryType.isTrackId((String)id)) {
                return this.createTrack(featureEntity, parameters, true, session);
            }
        }
        return null;
    }

    private FeatureEntity getFeatureEntity(String id, DbQuery parameters, Session session) throws DataAccessException {
        FeatureDao dao = new FeatureDao(session);
        long geometryId = Long.parseLong(GeometryType.extractId((String)id));
        return (FeatureEntity)dao.getInstance(geometryId, parameters);
    }

    private List<GeometryInfo> getAllSites(DbQuery parameters, Session session, boolean expanded) throws DataAccessException {
        ArrayList<GeometryInfo> geometryInfoList = new ArrayList<GeometryInfo>();
        FeatureDao dao = new FeatureDao(session);
        DbQuery siteQuery = this.dbQueryFactory.createFrom(parameters.getParameters().removeAllOf("platformTypes").extendWith("platformTypes", new String[]{"stationary"}));
        for (FeatureEntity featureEntity : dao.getAllInstances(siteQuery)) {
            GeometryInfo geometryInfo = this.createSite(featureEntity, parameters, expanded);
            if (geometryInfo == null) continue;
            geometryInfoList.add(geometryInfo);
        }
        return geometryInfoList;
    }

    private GeometryInfo createSite(FeatureEntity featureEntity, DbQuery parameters, boolean expanded) throws DataAccessException {
        Geometry geometry;
        GeometryInfo geomInfo = new GeometryInfo(GeometryType.PLATFORM_SITE);
        GeometryInfo geometryInfo = this.addCondensedValues(geomInfo, featureEntity, parameters);
        if (expanded && (geometry = featureEntity.getGeometry(this.getDatabaseSrid())) != null) {
            geometryInfo.setGeometry(geometry);
        }
        return geometryInfo;
    }

    private Collection<GeometryInfo> getAllTracks(DbQuery parameters, Session session, boolean expanded) throws DataAccessException {
        ArrayList<GeometryInfo> geometryInfoList = new ArrayList<GeometryInfo>();
        FeatureDao featureDao = new FeatureDao(session);
        DbQuery trackQuery = this.dbQueryFactory.createFrom(parameters.getParameters().removeAllOf("platformTypes").extendWith("platformTypes", new String[]{"mobile"}));
        for (FeatureEntity featureEntity : featureDao.getAllInstances(trackQuery)) {
            geometryInfoList.add(this.createTrack(featureEntity, parameters, expanded, session));
        }
        return geometryInfoList;
    }

    private GeometryInfo createTrack(FeatureEntity featureEntity, DbQuery parameters, boolean expanded, Session session) throws DataAccessException {
        GeometryInfo geomInfo = new GeometryInfo(GeometryType.PLATFORM_TRACK);
        GeometryInfo geometryInfo = this.addCondensedValues(geomInfo, featureEntity, parameters);
        if (expanded) {
            if (featureEntity.isSetGeometry()) {
                geometryInfo.setGeometry(featureEntity.getGeometry(this.getDatabaseSrid()));
                return geometryInfo;
            }
            Geometry lineString = this.createTrajectory(featureEntity, parameters, session);
            geometryInfo.setGeometry(lineString);
            return geometryInfo;
        }
        return geometryInfo;
    }

    private Geometry createTrajectory(FeatureEntity featureEntity, DbQuery dbQuery, Session session) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        if (DataModelUtil.isNamedQuerySupported(NAMED_QUERY_GET_SAMPLING_GEOMETRIES_FOR_FEATURE, session)) {
            Query query = session.getNamedQuery(NAMED_QUERY_GET_SAMPLING_GEOMETRIES_FOR_FEATURE);
            query.setLong(NAMED_QUERY_PARAMETER_FEATURE_ID, featureEntity.getPkid().longValue());
            for (Object entity : query.list()) {
                Object[] row = (Object[])entity;
                if (row.length > 2) {
                    coordinates.add(new Coordinate(((Double)row[1]).doubleValue(), ((Double)row[2]).doubleValue()));
                    continue;
                }
                Geometry geom = (Geometry)row[1];
                coordinates.add(geom.getCoordinate());
            }
            Coordinate[] points = coordinates.toArray(new Coordinate[0]);
            return this.getCrsUtils().createLineString(points, this.getDatabaseSrid());
        }
        SamplingGeometryDao dao = new SamplingGeometryDao(session);
        IoParameters parameters = dbQuery.getParameters().extendWith("features", new String[]{Long.toString(featureEntity.getPkid())});
        List<GeometryEntity> samplingGeometries = dao.getGeometriesOrderedByTimestamp(this.getDbQuery(parameters));
        return this.createLineString(samplingGeometries);
    }

    private Geometry createLineString(List<GeometryEntity> samplingGeometries) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (GeometryEntity geometryEntity : samplingGeometries) {
            Point geometry = (Point)geometryEntity.getGeometry(this.getDatabaseSrid());
            coordinates.add(geometry.getCoordinate());
        }
        return this.getCrsUtils().createLineString(coordinates.toArray(new Coordinate[0]), this.getDatabaseSrid());
    }

    private Collection<GeometryInfo> getAllObservedGeometriesStatic(DbQuery parameters, Session session, boolean expanded) {
        LOGGER.warn("Static ObservedGeometries not yet supported!");
        return new ArrayList<GeometryInfo>();
    }

    private Collection<GeometryInfo> getAllObservedGeometriesDynamic(DbQuery parameters, Session session, boolean expanded) {
        LOGGER.warn("Dynamic ObservedGeometries not yet supported!");
        return new ArrayList<GeometryInfo>();
    }

    private List<GeometryEntity> getAllObservedGeometries(DbQuery parameters, Session session) {
        LOGGER.warn("ObservedGeometries not yet supported!");
        return null;
    }

    private GeometryInfo addCondensedValues(GeometryInfo geometryInfo, FeatureEntity featureEntity, DbQuery parameters) throws DataAccessException {
        geometryInfo.setId(Long.toString(featureEntity.getPkid()));
        geometryInfo.setHrefBase(this.urlHelper.getGeometriesHrefBaseUrl(parameters.getHrefBase()));
        geometryInfo.setPlatform(this.getPlatfom(featureEntity, parameters));
        return geometryInfo;
    }

    private PlatformOutput getPlatfom(FeatureEntity entity, DbQuery parameters) throws DataAccessException {
        DbQuery platformQuery = this.dbQueryFactory.createFrom(parameters.getParameters().extendWith("features", new String[]{String.valueOf(entity.getPkid())}).extendWith("platformTypes", new String[]{"all"}));
        List<PlatformOutput> platforms = this.platformRepository.getAllCondensed(platformQuery);
        return platforms.iterator().next();
    }
}

