/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.OfferingOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.da.HierarchicalParameterRepository;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.OfferingDao;
import org.n52.series.spi.search.OfferingSearchResult;
import org.n52.series.spi.search.SearchResult;
import org.n52.web.exception.ResourceNotFoundException;

public class OfferingRepository
extends HierarchicalParameterRepository<OfferingEntity, OfferingOutput> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            OfferingDao dao = this.createDao(session);
            boolean bl = dao.hasInstance(this.parseId(id), parameters, OfferingEntity.class);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    private OfferingDao createDao(Session session) {
        return new OfferingDao(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        Session session = this.getSession();
        try {
            OfferingDao dao = this.createDao(session);
            DbQuery query = this.getDbQuery(parameters);
            List<OfferingEntity> found = dao.find(query);
            List<SearchResult> list = this.convertToSearchResults(found, query);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<SearchResult> convertToSearchResults(List<? extends DescribableEntity> found, DbQuery query) {
        String locale = query.getLocale();
        String hrefBase = this.urlHelper.getOfferingsHrefBaseUrl(query.getHrefBase());
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (DescribableEntity describableEntity : found) {
            String pkid = describableEntity.getPkid().toString();
            String label = describableEntity.getLabelFrom(locale);
            results.add((SearchResult)new OfferingSearchResult(pkid, label, hrefBase));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OfferingOutput> getAllCondensed(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<OfferingOutput> list = this.getAllCondensed(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<OfferingOutput> getAllCondensed(DbQuery parameters, Session session) throws DataAccessException {
        return this.createCondensed(this.getAllInstances(parameters, session), parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OfferingOutput> getAllExpanded(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<OfferingOutput> list = this.getAllExpanded(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<OfferingOutput> getAllExpanded(DbQuery parameters, Session session) throws DataAccessException {
        return this.createExpanded(this.getAllInstances(parameters, session), parameters);
    }

    @Override
    protected OfferingOutput createExpanded(OfferingEntity entity, DbQuery parameters) throws DataAccessException {
        OfferingOutput result = this.createCondensed(entity, parameters);
        if (parameters.getHrefBase() != null) {
            result.setService(this.getCondensedExtendedService(this.getServiceEntity(entity), parameters));
        } else {
            result.setService(this.getCondensedService(this.getServiceEntity(entity), parameters));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OfferingOutput getInstance(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            OfferingOutput offeringOutput = this.getInstance(id, parameters, session);
            return offeringOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public OfferingOutput getInstance(String id, DbQuery parameters, Session session) throws DataAccessException {
        OfferingEntity result = this.getInstance(this.parseId(id), parameters, session);
        return this.createExpanded(result, parameters);
    }

    private OfferingEntity getInstance(Long id, DbQuery parameters, Session session) throws DataAccessException {
        OfferingDao dao = this.createDao(session);
        OfferingEntity result = (OfferingEntity)dao.getInstance(id, parameters);
        if (result == null) {
            throw new ResourceNotFoundException("Resource with id '" + id + "' could not be found.");
        }
        return result;
    }

    private List<OfferingEntity> getAllInstances(DbQuery parameters, Session session) throws DataAccessException {
        return this.createDao(session).getAllInstances(parameters);
    }

    @Override
    protected OfferingOutput createCondensed(OfferingEntity entity, DbQuery parameters) {
        OfferingOutput result = new OfferingOutput();
        result.setLabel(entity.getLabelFrom(parameters.getLocale()));
        result.setId(Long.toString(entity.getPkid()));
        result.setDomainId(entity.getDomainId());
        this.checkForHref(result, parameters);
        return result;
    }

    private void checkForHref(OfferingOutput result, DbQuery parameters) {
        if (parameters.getHrefBase() != null) {
            result.setHrefBase(this.urlHelper.getOfferingsHrefBaseUrl(parameters.getHrefBase()));
        }
    }
}

