/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.PhenomenonOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.da.HierarchicalParameterRepository;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.PhenomenonDao;
import org.n52.series.spi.search.PhenomenonSearchResult;
import org.n52.series.spi.search.SearchResult;
import org.n52.web.exception.ResourceNotFoundException;

public class PhenomenonRepository
extends HierarchicalParameterRepository<PhenomenonEntity, PhenomenonOutput> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            PhenomenonDao dao = this.createDao(session);
            boolean bl = dao.hasInstance(this.parseId(id), parameters, PhenomenonEntity.class);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    private PhenomenonDao createDao(Session session) {
        return new PhenomenonDao(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        Session session = this.getSession();
        try {
            PhenomenonDao phenomenonDao = this.createDao(session);
            DbQuery query = this.getDbQuery(parameters);
            List<PhenomenonEntity> found = phenomenonDao.find(query);
            List<SearchResult> list = this.convertToSearchResults(found, query);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<SearchResult> convertToSearchResults(List<? extends DescribableEntity> found, DbQuery query) {
        String locale = query.getLocale();
        String hrefBase = this.urlHelper.getPhenomenaHrefBaseUrl(query.getHrefBase());
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (DescribableEntity describableEntity : found) {
            String pkid = describableEntity.getPkid().toString();
            String label = describableEntity.getLabelFrom(locale);
            results.add((SearchResult)new PhenomenonSearchResult(pkid, label, hrefBase));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PhenomenonOutput> getAllCondensed(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<PhenomenonOutput> list = this.getAllCondensed(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<PhenomenonOutput> getAllCondensed(DbQuery parameters, Session session) throws DataAccessException {
        return this.createCondensed(this.getAllInstances(parameters, session), parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PhenomenonOutput> getAllExpanded(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<PhenomenonOutput> list = this.getAllExpanded(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<PhenomenonOutput> getAllExpanded(DbQuery parameters, Session session) throws DataAccessException {
        return this.createExpanded(this.getAllInstances(parameters, session), parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PhenomenonOutput getInstance(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            PhenomenonOutput phenomenonOutput = this.getInstance(id, parameters, session);
            return phenomenonOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public PhenomenonOutput getInstance(String id, DbQuery parameters, Session session) throws DataAccessException {
        PhenomenonEntity result = this.getInstance(this.parseId(id), parameters, session);
        return this.createExpanded(result, parameters);
    }

    private PhenomenonEntity getInstance(Long id, DbQuery parameters, Session session) throws DataAccessException {
        PhenomenonDao phenomenonDao = this.createDao(session);
        PhenomenonEntity result = (PhenomenonEntity)phenomenonDao.getInstance(id, parameters);
        if (result == null) {
            throw new ResourceNotFoundException("Resource with id '" + id + "' could not be found.");
        }
        return result;
    }

    private List<PhenomenonEntity> getAllInstances(DbQuery parameters, Session session) throws DataAccessException {
        return this.createDao(session).getAllInstances(parameters);
    }

    @Override
    protected PhenomenonOutput createExpanded(PhenomenonEntity entity, DbQuery parameters) throws DataAccessException {
        PhenomenonOutput result = this.createCondensed(entity, parameters);
        if (parameters.getHrefBase() != null) {
            result.setService(this.getCondensedExtendedService(this.getServiceEntity(entity), parameters));
        } else {
            result.setService(this.getCondensedService(this.getServiceEntity(entity), parameters));
        }
        return result;
    }

    @Override
    protected PhenomenonOutput createCondensed(PhenomenonEntity entity, DbQuery parameters) {
        PhenomenonOutput result = new PhenomenonOutput();
        result.setLabel(entity.getLabelFrom(parameters.getLocale()));
        result.setId(Long.toString(entity.getPkid()));
        result.setDomainId(entity.getDomainId());
        this.checkForHref(result, parameters);
        return result;
    }

    private void checkForHref(PhenomenonOutput result, DbQuery parameters) {
        if (parameters.getHrefBase() != null) {
            result.setHrefBase(this.urlHelper.getPhenomenaHrefBaseUrl(parameters.getHrefBase()));
        }
    }
}

