/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.record.RecordData;
import org.n52.io.response.dataset.record.RecordDatasetMetadata;
import org.n52.io.response.dataset.record.RecordValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.RecordDataEntity;
import org.n52.series.db.beans.RecordDatasetEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public class RecordDataRepository
extends AbstractDataRepository<RecordData, RecordDatasetEntity, RecordDataEntity, RecordValue> {
    @Override
    public Class<RecordDatasetEntity> getDatasetEntityType() {
        return RecordDatasetEntity.class;
    }

    @Override
    protected RecordData assembleDataWithReferenceValues(RecordDatasetEntity timeseries, DbQuery dbQuery, Session session) throws DataAccessException {
        RecordData result = this.assembleData(timeseries, dbQuery, session);
        Set<RecordDatasetEntity> referenceValues = timeseries.getReferenceValues();
        if (referenceValues != null && !referenceValues.isEmpty()) {
            RecordDatasetMetadata metadata = new RecordDatasetMetadata();
            metadata.setReferenceValues(this.assembleReferenceSeries(referenceValues, dbQuery, session));
            result.setMetadata(metadata);
        }
        return result;
    }

    private Map<String, RecordData> assembleReferenceSeries(Set<RecordDatasetEntity> referenceValues, DbQuery query, Session session) throws DataAccessException {
        HashMap<String, RecordData> referenceSeries = new HashMap<String, RecordData>();
        for (RecordDatasetEntity referenceSeriesEntity : referenceValues) {
            if (!referenceSeriesEntity.isPublished().booleanValue()) continue;
            RecordData referenceSeriesData = this.assembleData(referenceSeriesEntity, query, session);
            if (this.haveToExpandReferenceData(referenceSeriesData)) {
                referenceSeriesData = this.expandReferenceDataIfNecessary(referenceSeriesEntity, query, session);
            }
            referenceSeries.put(Long.toString(referenceSeriesEntity.getPkid()), referenceSeriesData);
        }
        return referenceSeries;
    }

    private boolean haveToExpandReferenceData(RecordData referenceSeriesData) {
        return referenceSeriesData.getValues().size() <= 1;
    }

    private RecordData expandReferenceDataIfNecessary(RecordDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        RecordData result = new RecordData();
        DataDao dao = new DataDao(session);
        List observations = dao.getAllInstancesFor(seriesEntity, query);
        if (!this.hasValidEntriesWithinRequestedTimespan(observations)) {
            RecordValue lastValidValue = (RecordValue)this.getLastValue(seriesEntity, session, query);
            result.addValues((AbstractValue[])this.expandToInterval((Map)lastValidValue.getValue(), seriesEntity, query));
        }
        if (this.hasSingleValidReferenceValue(observations)) {
            RecordDataEntity entity = (RecordDataEntity)observations.get(0);
            result.addValues((AbstractValue[])this.expandToInterval((Map)entity.getValue(), seriesEntity, query));
        }
        return result;
    }

    @Override
    protected RecordData assembleData(RecordDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        RecordData result = new RecordData();
        DataDao dao = new DataDao(session);
        List observations = dao.getAllInstancesFor(seriesEntity, query);
        for (RecordDataEntity observation : observations) {
            if (observation == null) continue;
            result.addValues((AbstractValue[])new RecordValue[]{this.createSeriesValueFor(observation, seriesEntity, query)});
        }
        return result;
    }

    private RecordValue[] expandToInterval(Map<String, Object> value, RecordDatasetEntity series, DbQuery query) {
        RecordDataEntity referenceStart = new RecordDataEntity(){};
        RecordDataEntity referenceEnd = new RecordDataEntity(){};
        referenceStart.setTimestamp(query.getTimespan().getStart().toDate());
        referenceEnd.setTimestamp(query.getTimespan().getEnd().toDate());
        referenceStart.setValue(value);
        referenceEnd.setValue(value);
        return new RecordValue[]{this.createSeriesValueFor(referenceStart, series, query), this.createSeriesValueFor(referenceEnd, series, query)};
    }

    @Override
    public RecordValue createSeriesValueFor(RecordDataEntity observation, RecordDatasetEntity series, DbQuery query) {
        RecordValue value;
        if (observation == null) {
            return null;
        }
        ServiceEntity service = this.getServiceEntity(series);
        Map observationValue = !service.isNoDataValue(observation) ? (Map)observation.getValue() : null;
        Date timeend = observation.getTimeend();
        Date timestart = observation.getTimestart();
        long end = timeend.getTime();
        long start = timestart.getTime();
        IoParameters parameters = query.getParameters();
        RecordValue recordValue = value = parameters.isShowTimeIntervals() ? new RecordValue(Long.valueOf(start), Long.valueOf(end), observationValue) : new RecordValue(Long.valueOf(end), observationValue);
        if (query.isExpanded()) {
            this.addGeometry(observation, (AbstractValue<?>)value);
            this.addValidTime(observation, (AbstractValue<?>)value);
            this.addParameters(observation, (AbstractValue<?>)value, query);
        } else if (series.getPlatform().isMobile()) {
            this.addGeometry(observation, (AbstractValue<?>)value);
        }
        return value;
    }
}

