/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.n52.io.DatasetFactoryException;
import org.n52.io.DefaultIoFactory;
import org.n52.io.IoFactory;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;
import org.n52.io.response.ServiceOutput;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.da.EntityCounter;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.ServiceDao;
import org.n52.series.spi.search.FeatureSearchResult;
import org.n52.series.spi.search.SearchResult;
import org.n52.web.exception.InternalServerException;
import org.n52.web.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceRepository
extends SessionAwareRepository
implements OutputAssembler<ServiceOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRepository.class);
    private static final String SERVICE_TYPE = "Restful series access layer.";
    @Autowired
    private EntityCounter counter;
    @Autowired
    private DefaultIoFactory<Data<AbstractValue<?>>, DatasetOutput<AbstractValue<?>, ?>, AbstractValue<?>> ioFactoryCreator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        if (this.serviceEntity != null) {
            return String.valueOf(this.serviceEntity.getPkid()).equalsIgnoreCase(id);
        }
        Session session = this.getSession();
        try {
            ServiceDao dao = this.createDao(session);
            boolean bl = dao.hasInstance(this.parseId(id), parameters, ServiceEntity.class);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public List<SearchResult> convertToSearchResults(List<? extends DescribableEntity> found, DbQuery query) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        String locale = query.getLocale();
        for (DescribableEntity describableEntity : found) {
            String pkid = Long.toString(describableEntity.getPkid());
            String label = describableEntity.getLabelFrom(locale);
            String hrefBase = this.urlHelper.getFeaturesHrefBaseUrl(query.getHrefBase());
            results.add((SearchResult)new FeatureSearchResult(pkid, label, hrefBase));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServiceOutput> getAllCondensed(DbQuery parameters) throws DataAccessException {
        if (this.serviceEntity != null) {
            return Collections.singletonList(this.getCondensedService(this.serviceEntity, parameters));
        }
        Session session = this.getSession();
        try {
            List<ServiceOutput> list = this.getAllCondensed(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<ServiceOutput> getAllCondensed(DbQuery parameters, Session session) throws DataAccessException {
        if (this.serviceEntity != null) {
            return Collections.singletonList(this.getCondensedService(this.serviceEntity, parameters));
        }
        ArrayList<ServiceOutput> results = new ArrayList<ServiceOutput>();
        for (ServiceEntity entity : this.getAllInstances(parameters, session)) {
            results.add(this.getCondensedService(entity, parameters));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServiceOutput> getAllExpanded(DbQuery parameters) throws DataAccessException {
        if (this.serviceEntity != null) {
            return Collections.singletonList(this.createExpandedService(this.serviceEntity, parameters));
        }
        Session session = this.getSession();
        try {
            List<ServiceOutput> list = this.getAllExpanded(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<ServiceOutput> getAllExpanded(DbQuery parameters, Session session) throws DataAccessException {
        if (this.serviceEntity != null) {
            return Collections.singletonList(this.createExpandedService(this.serviceEntity, parameters));
        }
        ArrayList<ServiceOutput> results = new ArrayList<ServiceOutput>();
        for (ServiceEntity entity : this.getAllInstances(parameters, session)) {
            results.add(this.createExpandedService(entity, parameters));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceOutput getInstance(String id, DbQuery parameters) throws DataAccessException {
        if (this.serviceEntity != null) {
            return this.createExpandedService(this.serviceEntity, parameters);
        }
        Session session = this.getSession();
        try {
            ServiceOutput serviceOutput = this.getInstance(id, parameters, session);
            return serviceOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public ServiceOutput getInstance(String id, DbQuery parameters, Session session) throws DataAccessException {
        if (this.serviceEntity != null) {
            return this.createExpandedService(this.serviceEntity, parameters);
        }
        ServiceEntity result = this.getInstance(this.parseId(id), parameters, session);
        return this.createExpandedService(result, parameters);
    }

    private ServiceEntity getInstance(Long id, DbQuery parameters, Session session) throws DataAccessException {
        ServiceDao serviceDAO = this.createDao(session);
        ServiceEntity result = (ServiceEntity)serviceDAO.getInstance(id, parameters);
        if (result == null) {
            throw new ResourceNotFoundException("Resource with id '" + id + "' could not be found.");
        }
        return result;
    }

    private List<ServiceEntity> getAllInstances(DbQuery parameters, Session session) throws DataAccessException {
        return this.createDao(session).getAllInstances(parameters);
    }

    private ServiceDao createDao(Session session) {
        return new ServiceDao(session);
    }

    private ServiceOutput createExpandedService(ServiceEntity entity, DbQuery parameters) {
        ServiceOutput service = this.getCondensedService(entity, parameters);
        service.setQuantities(this.countParameters(service, parameters));
        service.setServiceUrl(entity.getUrl());
        service.setSupportsFirstLatest(Boolean.valueOf(true));
        FilterResolver filterResolver = parameters.getFilterResolver();
        if (filterResolver.shallBehaveBackwardsCompatible()) {
            service.setVersion("1.0.0");
            service.setType(SERVICE_TYPE);
        } else {
            service.setType(entity.getType() == null ? SERVICE_TYPE : entity.getType());
            service.setVersion(entity.getVersion() != null ? entity.getVersion() : "2.0");
            this.addSupportedDatasetsTo(service);
        }
        return service;
    }

    private void addSupportedDatasetsTo(ServiceOutput service) {
        HashMap<String, Set> mimeTypesByDatasetTypes = new HashMap<String, Set>();
        for (String valueType : this.ioFactoryCreator.getKnownTypes()) {
            try {
                IoFactory factory = (IoFactory)this.ioFactoryCreator.create(valueType);
                mimeTypesByDatasetTypes.put(valueType, factory.getSupportedMimeTypes());
            }
            catch (DatasetFactoryException e) {
                LOGGER.error("IO Factory for type '{}' couldn't be created.", (Object)valueType);
            }
        }
        service.addSupportedDatasets(mimeTypesByDatasetTypes);
    }

    private ServiceOutput.ParameterCount countParameters(ServiceOutput service, DbQuery query) {
        try {
            ServiceOutput.ParameterCount quantities = new ServiceOutput.ParameterCount();
            DbQuery serviceQuery = this.getDbQuery(query.getParameters().extendWith("services", new String[]{service.getId()}));
            quantities.setOfferingsSize(this.counter.countOfferings(serviceQuery));
            quantities.setProceduresSize(this.counter.countProcedures(serviceQuery));
            quantities.setCategoriesSize(this.counter.countCategories(serviceQuery));
            quantities.setPhenomenaSize(this.counter.countPhenomena(serviceQuery));
            quantities.setFeaturesSize(this.counter.countFeatures(serviceQuery));
            quantities.setPlatformsSize(this.counter.countPlatforms(serviceQuery));
            quantities.setDatasetsSize(this.counter.countDatasets(serviceQuery));
            FilterResolver filterResolver = query.getFilterResolver();
            if (filterResolver.shallBehaveBackwardsCompatible()) {
                quantities.setTimeseriesSize(this.counter.countTimeseries().intValue());
                quantities.setStationsSize(this.counter.countStations().intValue());
            }
            return quantities;
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Could not count parameter entities.", (Throwable)e);
        }
    }
}

