/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.n52.io.crs.CRSUtils;
import org.n52.io.request.IoParameters;
import org.n52.io.response.CategoryOutput;
import org.n52.io.response.FeatureOutput;
import org.n52.io.response.OfferingOutput;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.PhenomenonOutput;
import org.n52.io.response.ProcedureOutput;
import org.n52.io.response.ServiceOutput;
import org.n52.io.response.dataset.SeriesParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.HibernateSessionStore;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.QuantityDatasetEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.DbQueryFactory;
import org.n52.web.ctrl.UrlHelper;
import org.n52.web.exception.BadRequestException;
import org.n52.web.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SessionAwareRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionAwareRepository.class);
    protected UrlHelper urlHelper = new UrlHelper();
    @Autowired(required=false)
    protected ServiceEntity serviceEntity;
    @Autowired
    protected DbQueryFactory dbQueryFactory;
    private final CRSUtils crsUtils = CRSUtils.createEpsgStrictAxisOrder();
    private String databaseSrid;
    @Autowired
    private HibernateSessionStore sessionStore;

    protected DbQuery getDbQuery(IoParameters parameters) {
        return this.dbQueryFactory.createFrom(parameters);
    }

    public HibernateSessionStore getSessionStore() {
        return this.sessionStore;
    }

    public void setSessionStore(HibernateSessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    protected CRSUtils getCrsUtils() {
        return this.crsUtils;
    }

    protected String getDatabaseSrid() {
        return this.databaseSrid;
    }

    protected Long parseId(String id) throws BadRequestException {
        try {
            return Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Unable to parse {} to Long.", (Throwable)e);
            throw new ResourceNotFoundException("Resource with id '" + id + "' could not be found.");
        }
    }

    public void returnSession(Session session) {
        this.sessionStore.returnSession(session);
    }

    public Session getSession() {
        try {
            return this.sessionStore.getSession();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not get hibernate session.", e);
        }
    }

    public void setDatabaseSrid(String databaseSrid) {
        this.databaseSrid = databaseSrid;
    }

    protected Map<String, SeriesParameters> createTimeseriesList(List<QuantityDatasetEntity> series, DbQuery parameters) throws DataAccessException {
        HashMap<String, SeriesParameters> timeseriesOutputs = new HashMap<String, SeriesParameters>();
        for (QuantityDatasetEntity timeseries : series) {
            if (timeseries.getProcedure().isReference()) continue;
            String timeseriesId = Long.toString(timeseries.getPkid());
            timeseriesOutputs.put(timeseriesId, this.createTimeseriesOutput(timeseries, parameters));
        }
        return timeseriesOutputs;
    }

    protected SeriesParameters createTimeseriesOutput(QuantityDatasetEntity series, DbQuery parameters) throws DataAccessException {
        SeriesParameters metadata = new SeriesParameters();
        ServiceEntity service = this.getServiceEntity(series);
        metadata.setService((ParameterOutput)this.getCondensedService(service, parameters));
        metadata.setOffering((ParameterOutput)this.getCondensedOffering(series.getOffering(), parameters));
        metadata.setProcedure((ParameterOutput)this.getCondensedProcedure(series.getProcedure(), parameters));
        metadata.setPhenomenon((ParameterOutput)this.getCondensedPhenomenon(series.getPhenomenon(), parameters));
        metadata.setFeature((ParameterOutput)this.getCondensedFeature(series.getFeature(), parameters));
        metadata.setCategory((ParameterOutput)this.getCondensedCategory(series.getCategory(), parameters));
        return metadata;
    }

    protected SeriesParameters createSeriesParameters(DatasetEntity<?> series, DbQuery parameters, Session session) throws DataAccessException {
        SeriesParameters metadata = new SeriesParameters();
        ServiceEntity service = this.getServiceEntity(series);
        metadata.setService((ParameterOutput)this.getCondensedExtendedService(service, parameters));
        metadata.setOffering((ParameterOutput)this.getCondensedExtendedOffering(series.getOffering(), parameters));
        metadata.setProcedure((ParameterOutput)this.getCondensedExtendedProcedure(series.getProcedure(), parameters));
        metadata.setPhenomenon((ParameterOutput)this.getCondensedExtendedPhenomenon(series.getPhenomenon(), parameters));
        metadata.setFeature((ParameterOutput)this.getCondensedExtendedFeature(series.getFeature(), parameters));
        metadata.setCategory((ParameterOutput)this.getCondensedExtendedCategory(series.getCategory(), parameters));
        return metadata;
    }

    protected PhenomenonOutput getCondensedPhenomenon(PhenomenonEntity entity, DbQuery parameters) {
        return this.createCondensed(new PhenomenonOutput(), entity, parameters);
    }

    protected PhenomenonOutput getCondensedExtendedPhenomenon(PhenomenonEntity entity, DbQuery parameters) {
        return this.createCondensed(new PhenomenonOutput(), entity, parameters, this.urlHelper.getPhenomenaHrefBaseUrl(parameters.getHrefBase()));
    }

    protected OfferingOutput getCondensedOffering(OfferingEntity entity, DbQuery parameters) {
        return this.createCondensed(new OfferingOutput(), entity, parameters);
    }

    protected ServiceOutput getCondensedService(ServiceEntity entity, DbQuery parameters) {
        return this.createCondensed(new ServiceOutput(), entity, parameters);
    }

    protected OfferingOutput getCondensedExtendedOffering(OfferingEntity entity, DbQuery parameters) {
        return this.createCondensed(new OfferingOutput(), entity, parameters, this.urlHelper.getOfferingsHrefBaseUrl(parameters.getHrefBase()));
    }

    public void setServiceEntity(ServiceEntity serviceEntity) {
        this.serviceEntity = serviceEntity;
    }

    protected ServiceEntity getServiceEntity() {
        return this.serviceEntity;
    }

    protected ServiceEntity getServiceEntity(DescribableEntity entity) {
        this.assertServiceAvailable(entity);
        return entity.getService() != null ? entity.getService() : this.serviceEntity;
    }

    protected ServiceOutput getCondensedExtendedService(ServiceEntity entity, DbQuery parameters) {
        String hrefBase = this.urlHelper.getServicesHrefBaseUrl(parameters.getHrefBase());
        return this.createCondensed(new ServiceOutput(), entity, parameters, hrefBase);
    }

    protected <T extends ParameterOutput> T createCondensed(T outputvalue, DescribableEntity entity, DbQuery parameters) {
        outputvalue.setLabel(entity.getLabelFrom(parameters.getLocale()));
        outputvalue.setId(Long.toString(entity.getPkid()));
        return outputvalue;
    }

    private <T extends ParameterOutput> T createCondensed(T outputvalue, DescribableEntity entity, DbQuery parameters, String hrefBase) {
        this.createCondensed(outputvalue, entity, parameters);
        outputvalue.setHref(hrefBase + "/" + outputvalue.getId());
        return outputvalue;
    }

    protected ProcedureOutput getCondensedProcedure(ProcedureEntity entity, DbQuery parameters) {
        return this.createCondensed(new ProcedureOutput(), entity, parameters);
    }

    protected ProcedureOutput getCondensedExtendedProcedure(ProcedureEntity entity, DbQuery parameters) {
        return this.createCondensed(new ProcedureOutput(), entity, parameters, this.urlHelper.getProceduresHrefBaseUrl(parameters.getHrefBase()));
    }

    protected FeatureOutput getCondensedFeature(FeatureEntity entity, DbQuery parameters) {
        return this.createCondensed(new FeatureOutput(), entity, parameters);
    }

    protected FeatureOutput getCondensedExtendedFeature(FeatureEntity entity, DbQuery parameters) {
        return this.createCondensed(new FeatureOutput(), entity, parameters, this.urlHelper.getFeaturesHrefBaseUrl(parameters.getHrefBase()));
    }

    protected CategoryOutput getCondensedCategory(CategoryEntity entity, DbQuery parameters) {
        return this.createCondensed(new CategoryOutput(), entity, parameters);
    }

    protected CategoryOutput getCondensedExtendedCategory(CategoryEntity entity, DbQuery parameters) {
        return this.createCondensed(new CategoryOutput(), entity, parameters, this.urlHelper.getCategoriesHrefBaseUrl(parameters.getHrefBase()));
    }

    private void assertServiceAvailable(DescribableEntity entity) throws IllegalStateException {
        if (this.serviceEntity == null && entity == null) {
            throw new IllegalStateException("No service instance available");
        }
    }
}

