/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.text.TextData;
import org.n52.io.response.dataset.text.TextDatasetMetadata;
import org.n52.io.response.dataset.text.TextValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.TextDataEntity;
import org.n52.series.db.beans.TextDatasetEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public class TextDataRepository
extends AbstractDataRepository<TextData, TextDatasetEntity, TextDataEntity, TextValue> {
    @Override
    public Class<TextDatasetEntity> getDatasetEntityType() {
        return TextDatasetEntity.class;
    }

    @Override
    protected TextData assembleDataWithReferenceValues(TextDatasetEntity timeseries, DbQuery dbQuery, Session session) throws DataAccessException {
        TextData result = this.assembleData(timeseries, dbQuery, session);
        Set<TextDatasetEntity> referenceValues = timeseries.getReferenceValues();
        if (referenceValues != null && !referenceValues.isEmpty()) {
            TextDatasetMetadata metadata = new TextDatasetMetadata();
            metadata.setReferenceValues(this.assembleReferenceSeries(referenceValues, dbQuery, session));
            result.setMetadata(metadata);
        }
        return result;
    }

    private Map<String, TextData> assembleReferenceSeries(Set<TextDatasetEntity> referenceValues, DbQuery query, Session session) throws DataAccessException {
        HashMap<String, TextData> referenceSeries = new HashMap<String, TextData>();
        for (TextDatasetEntity referenceSeriesEntity : referenceValues) {
            if (!referenceSeriesEntity.isPublished().booleanValue()) continue;
            TextData referenceSeriesData = this.assembleData(referenceSeriesEntity, query, session);
            if (this.haveToExpandReferenceData(referenceSeriesData)) {
                referenceSeriesData = this.expandReferenceDataIfNecessary(referenceSeriesEntity, query, session);
            }
            referenceSeries.put(Long.toString(referenceSeriesEntity.getPkid()), referenceSeriesData);
        }
        return referenceSeries;
    }

    private boolean haveToExpandReferenceData(TextData referenceSeriesData) {
        List values = referenceSeriesData.getValues();
        return values.size() <= 1;
    }

    private TextData expandReferenceDataIfNecessary(TextDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        TextData result = new TextData();
        DataDao dao = new DataDao(session);
        List observations = dao.getAllInstancesFor(seriesEntity, query);
        if (!this.hasValidEntriesWithinRequestedTimespan(observations)) {
            TextValue lastValidValue = (TextValue)this.getLastValue(seriesEntity, session, query);
            result.addValues((AbstractValue[])this.expandToInterval((String)lastValidValue.getValue(), seriesEntity, query));
        }
        if (this.hasSingleValidReferenceValue(observations)) {
            TextDataEntity entity = (TextDataEntity)observations.get(0);
            result.addValues((AbstractValue[])this.expandToInterval((String)entity.getValue(), seriesEntity, query));
        }
        return result;
    }

    @Override
    protected TextData assembleData(TextDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        TextData result = new TextData();
        DataDao dao = new DataDao(session);
        List observations = dao.getAllInstancesFor(seriesEntity, query);
        for (TextDataEntity observation : observations) {
            if (observation == null) continue;
            result.addValues((AbstractValue[])new TextValue[]{this.createSeriesValueFor(observation, seriesEntity, query)});
        }
        return result;
    }

    private TextValue[] expandToInterval(String value, TextDatasetEntity series, DbQuery query) {
        TextDataEntity referenceStart = new TextDataEntity();
        TextDataEntity referenceEnd = new TextDataEntity();
        referenceStart.setTimestamp(query.getTimespan().getStart().toDate());
        referenceEnd.setTimestamp(query.getTimespan().getEnd().toDate());
        referenceStart.setValue(value);
        referenceEnd.setValue(value);
        return new TextValue[]{this.createSeriesValueFor(referenceStart, series, query), this.createSeriesValueFor(referenceEnd, series, query)};
    }

    @Override
    public TextValue createSeriesValueFor(TextDataEntity observation, TextDatasetEntity series, DbQuery query) {
        TextValue value;
        if (observation == null) {
            return null;
        }
        ServiceEntity service = this.getServiceEntity(series);
        String observationValue = !service.isNoDataValue(observation) ? (String)observation.getValue() : null;
        Date timeend = observation.getTimeend();
        Date timestart = observation.getTimestart();
        long end = timeend.getTime();
        long start = timestart.getTime();
        IoParameters parameters = query.getParameters();
        TextValue textValue = value = parameters.isShowTimeIntervals() ? new TextValue(Long.valueOf(start), Long.valueOf(end), observationValue) : new TextValue(Long.valueOf(end), observationValue);
        if (query.isExpanded()) {
            this.addGeometry(observation, (AbstractValue<?>)value);
            this.addValidTime(observation, (AbstractValue<?>)value);
            this.addParameters(observation, (AbstractValue<?>)value, query);
        } else if (series.getPlatform().isMobile()) {
            this.addGeometry(observation, (AbstractValue<?>)value);
        }
        return value;
    }
}

