/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.n52.io.DatasetFactoryException;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.ReferenceValueOutput;
import org.n52.io.response.dataset.StationOutput;
import org.n52.io.response.dataset.TimeseriesMetadataOutput;
import org.n52.io.response.dataset.quantity.QuantityReferenceValueOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.QuantityDatasetEntity;
import org.n52.series.db.da.IDataRepositoryFactory;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.QuantityDataRepository;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.da.StationRepository;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.spi.search.SearchResult;
import org.n52.series.spi.search.TimeseriesSearchResult;
import org.n52.web.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Deprecated
public class TimeseriesRepository
extends SessionAwareRepository
implements OutputAssembler<TimeseriesMetadataOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeseriesRepository.class);
    @Autowired
    @Qualifier(value="stationRepository")
    private OutputAssembler<StationOutput> stationRepository;
    @Autowired
    private IDataRepositoryFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            DatasetDao<QuantityDatasetEntity> dao = this.createDao(session);
            boolean bl = dao.hasInstance(this.parseId(id), parameters, QuantityDatasetEntity.class);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    private DatasetDao<QuantityDatasetEntity> createDao(Session session) {
        return new DatasetDao<QuantityDatasetEntity>(session, QuantityDatasetEntity.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        Session session = this.getSession();
        try {
            DatasetDao<QuantityDatasetEntity> seriesDao = this.createDao(session);
            DbQuery query = this.dbQueryFactory.createFrom(parameters);
            List<QuantityDatasetEntity> found = seriesDao.find(query);
            List<SearchResult> list = this.convertToResults(found, query.getLocale());
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<SearchResult> convertToSearchResults(List<? extends DescribableEntity> found, DbQuery query) {
        return Collections.emptyList();
    }

    private List<SearchResult> convertToResults(List<QuantityDatasetEntity> found, String locale) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (QuantityDatasetEntity searchResult : found) {
            String pkid = searchResult.getPkid().toString();
            String phenomenonLabel = searchResult.getPhenomenon().getLabelFrom(locale);
            String procedureLabel = searchResult.getProcedure().getLabelFrom(locale);
            String stationLabel = searchResult.getFeature().getLabelFrom(locale);
            String offeringLabel = searchResult.getOffering().getLabelFrom(locale);
            String label = this.createTimeseriesLabel(phenomenonLabel, procedureLabel, stationLabel, offeringLabel);
            results.add((SearchResult)new TimeseriesSearchResult(pkid, label));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TimeseriesMetadataOutput> getAllCondensed(DbQuery query) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<TimeseriesMetadataOutput> list = this.getAllCondensed(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<TimeseriesMetadataOutput> getAllCondensed(DbQuery query, Session session) throws DataAccessException {
        ArrayList<TimeseriesMetadataOutput> results = new ArrayList<TimeseriesMetadataOutput>();
        DatasetDao<QuantityDatasetEntity> seriesDao = this.createDao(session);
        for (QuantityDatasetEntity timeseries : seriesDao.getAllInstances(query)) {
            results.add(this.createCondensed(timeseries, query, session));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TimeseriesMetadataOutput> getAllExpanded(DbQuery query) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<TimeseriesMetadataOutput> list = this.getAllExpanded(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<TimeseriesMetadataOutput> getAllExpanded(DbQuery query, Session session) throws DataAccessException {
        ArrayList<TimeseriesMetadataOutput> results = new ArrayList<TimeseriesMetadataOutput>();
        DatasetDao<QuantityDatasetEntity> seriesDao = this.createDao(session);
        for (QuantityDatasetEntity timeseries : seriesDao.getAllInstances(query)) {
            results.add(this.createExpanded(timeseries, query, session));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeseriesMetadataOutput getInstance(String timeseriesId, DbQuery dbQuery) throws DataAccessException {
        Session session = this.getSession();
        try {
            TimeseriesMetadataOutput timeseriesMetadataOutput = this.getInstance(timeseriesId, dbQuery, session);
            return timeseriesMetadataOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public TimeseriesMetadataOutput getInstance(String timeseriesId, DbQuery dbQuery, Session session) throws DataAccessException {
        DatasetDao<QuantityDatasetEntity> seriesDao = this.createDao(session);
        QuantityDatasetEntity result = (QuantityDatasetEntity)seriesDao.getInstance(this.parseId(timeseriesId), dbQuery);
        if (result == null) {
            throw new ResourceNotFoundException("Resource with id '" + timeseriesId + "' could not be found.");
        }
        return this.createExpanded(result, dbQuery, session);
    }

    protected TimeseriesMetadataOutput createExpanded(QuantityDatasetEntity series, DbQuery query, Session session) throws DataAccessException {
        TimeseriesMetadataOutput output = this.createCondensed(series, query, session);
        output.setSeriesParameters(this.createTimeseriesOutput(series, query));
        QuantityDataRepository repository = this.createRepository("quantity");
        output.setReferenceValues((ReferenceValueOutput[])this.createReferenceValueOutputs(series, query, repository));
        output.setFirstValue(repository.getFirstValue(series, session, query));
        output.setLastValue(repository.getLastValue(series, session, query));
        return output;
    }

    private QuantityDataRepository createRepository(String valueType) throws DataAccessException {
        if (!"quantity".equalsIgnoreCase(valueType)) {
            throw new ResourceNotFoundException("unknown value type: " + valueType);
        }
        try {
            return (QuantityDataRepository)this.factory.create("quantity");
        }
        catch (DatasetFactoryException e) {
            throw new DataAccessException(e.getMessage());
        }
    }

    private QuantityReferenceValueOutput[] createReferenceValueOutputs(QuantityDatasetEntity series, DbQuery query, QuantityDataRepository repository) throws DataAccessException {
        ArrayList<QuantityReferenceValueOutput> outputs = new ArrayList<QuantityReferenceValueOutput>();
        Set<QuantityDatasetEntity> referenceValues = series.getReferenceValues();
        for (QuantityDatasetEntity referenceSeriesEntity : referenceValues) {
            if (!referenceSeriesEntity.isPublished().booleanValue()) continue;
            QuantityReferenceValueOutput refenceValueOutput = new QuantityReferenceValueOutput();
            ProcedureEntity procedure = referenceSeriesEntity.getProcedure();
            refenceValueOutput.setLabel(procedure.getNameI18n(query.getLocale()));
            refenceValueOutput.setReferenceValueId(referenceSeriesEntity.getPkid().toString());
            QuantityDataEntity lastValue = referenceSeriesEntity.getLastValue();
            refenceValueOutput.setLastValue(repository.createSeriesValueFor(lastValue, referenceSeriesEntity, query));
            outputs.add(refenceValueOutput);
        }
        return outputs.toArray(new QuantityReferenceValueOutput[0]);
    }

    private TimeseriesMetadataOutput createCondensed(QuantityDatasetEntity entity, DbQuery query, Session session) throws DataAccessException {
        TimeseriesMetadataOutput output = new TimeseriesMetadataOutput();
        String locale = query.getLocale();
        String phenomenonLabel = entity.getPhenomenon().getLabelFrom(locale);
        String procedureLabel = entity.getProcedure().getLabelFrom(locale);
        String stationLabel = entity.getFeature().getLabelFrom(locale);
        String offeringLabel = entity.getOffering().getLabelFrom(locale);
        output.setLabel(this.createTimeseriesLabel(phenomenonLabel, procedureLabel, stationLabel, offeringLabel));
        output.setId(entity.getPkid().toString());
        output.setUom(entity.getUnitI18nName(locale));
        output.setStation(this.createCondensedStation(entity, query, session));
        return output;
    }

    private String createTimeseriesLabel(String phenomenon, String procedure, String station, String offering) {
        StringBuilder sb = new StringBuilder();
        sb.append(phenomenon).append(" ");
        sb.append(procedure).append(", ");
        sb.append(station).append(", ");
        return sb.append(offering).toString();
    }

    private StationOutput createCondensedStation(QuantityDatasetEntity entity, DbQuery query, Session session) throws DataAccessException {
        FeatureEntity feature = entity.getFeature();
        String featurePkid = Long.toString(feature.getPkid());
        return ((StationRepository)this.stationRepository).getCondensedInstance(featurePkid, query, session);
    }

    public OutputAssembler<StationOutput> getStationRepository() {
        return this.stationRepository;
    }

    public void setStationRepository(OutputAssembler<StationOutput> stationRepository) {
        this.stationRepository = stationRepository;
    }
}

