/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.I18nEntity;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.GenericDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDao<T>
implements GenericDao<T, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDao.class);
    protected Session session;

    public AbstractDao(Session session) {
        if (session == null) {
            throw new NullPointerException("Cannot operate on a null session.");
        }
        this.session = session;
    }

    public abstract List<T> find(DbQuery var1);

    protected abstract Class<T> getEntityClass();

    protected abstract String getDatasetProperty();

    public boolean hasInstance(String id, DbQuery query, Class<? extends T> clazz) throws DataAccessException {
        return this.getInstance(id, query) != null;
    }

    @Override
    public boolean hasInstance(Long id, DbQuery query, Class<? extends T> clazz) {
        return this.session.get(clazz, (Serializable)id) != null;
    }

    @Override
    public T getInstance(String key, DbQuery parameters) throws DataAccessException {
        if (!parameters.getParameters().isMatchDomainIds()) {
            return this.getInstance(Long.parseLong(key), parameters);
        }
        LOGGER.debug("get dataset type for '{}'. {}", (Object)key, (Object)parameters);
        Criteria criteria = this.getDefaultCriteria();
        return this.getEntityClass().cast(criteria.add((Criterion)Restrictions.eq((String)"domainId", (Object)key)).uniqueResult());
    }

    @Override
    public T getInstance(Long key, DbQuery parameters) throws DataAccessException {
        LOGGER.debug("get instance '{}': {}", (Object)key, (Object)parameters);
        Criteria criteria = this.getDefaultCriteria();
        return this.getEntityClass().cast(criteria.add((Criterion)Restrictions.eq((String)"pkid", (Object)key)).uniqueResult());
    }

    @Override
    public Integer getCount(DbQuery query) throws DataAccessException {
        Criteria criteria = this.getDefaultCriteria().setProjection(Projections.rowCount());
        return ((Long)query.addFilters(criteria, this.getDatasetProperty()).uniqueResult()).intValue();
    }

    protected <I extends I18nEntity> Criteria i18n(Class<I> clazz, Criteria criteria, DbQuery query) {
        return this.hasTranslation(query, clazz) ? query.addLocaleTo(criteria, clazz) : criteria;
    }

    private <I extends I18nEntity> boolean hasTranslation(DbQuery parameters, Class<I> clazz) {
        Criteria i18nCriteria = this.session.createCriteria(clazz);
        return parameters.checkTranslationForLocale(i18nCriteria);
    }

    protected Criteria getDefaultCriteria() {
        return this.getDefaultCriteria(this.getDatasetProperty());
    }

    protected Criteria getDefaultCriteria(String alias) {
        return alias == null || alias.isEmpty() ? this.session.createCriteria(this.getEntityClass()) : this.session.createCriteria(this.getEntityClass(), alias);
    }
}

