/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.criterion.Subqueries;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.n52.io.request.IoParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.DbQueryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DataDao<T extends DataEntity>
extends AbstractDao<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataDao.class);
    private static final String COLUMN_SERIES_PKID = "seriesPkid";
    private static final String COLUMN_DELETED = "deleted";
    private static final String COLUMN_RESULTTIME = "resultTime";
    private static final String COLUMN_TIMESTART = "timestart";
    private static final String COLUMN_TIMEEND = "timeend";
    private static final String COLUMN_PARENT = "parent";
    private final Class<T> entityType;
    @Autowired
    private DbQueryFactory dbQueryFactory;

    public DataDao(Session session, Class<T> clazz) {
        super(session);
        this.entityType = clazz;
    }

    public DataDao(Session session) {
        super(session);
        this.entityType = DataEntity.class;
    }

    @Override
    public List<T> find(DbQuery query) {
        LOGGER.debug("find instances: {}", (Object)query);
        return Collections.emptyList();
    }

    @Override
    public T getInstance(Long key, DbQuery parameters) throws DataAccessException {
        LOGGER.debug("get instance '{}': {}", (Object)key, (Object)parameters);
        return (T)((DataEntity)this.entityType.cast(this.session.get(this.entityType, (Serializable)key)));
    }

    @Override
    public List<T> getAllInstances(DbQuery parameters) throws DataAccessException {
        LOGGER.debug("get all instances: {}", (Object)parameters);
        Criteria criteria = this.getDefaultCriteria(parameters);
        parameters.addTimespanTo(criteria);
        return criteria.list();
    }

    public List<T> getAllInstancesFor(DatasetEntity series) throws DataAccessException {
        LOGGER.debug("get all instances for series '{}'", (Object)series.getPkid());
        return this.getAllInstancesFor(series, this.dbQueryFactory.createFrom(IoParameters.createDefaults()));
    }

    public List<T> getAllInstancesFor(DatasetEntity series, DbQuery parameters) throws DataAccessException {
        Long pkid = series.getPkid();
        LOGGER.debug("get all instances for series '{}': {}", (Object)pkid, (Object)parameters);
        SimpleExpression equalsPkid = Restrictions.eq((String)COLUMN_SERIES_PKID, (Object)pkid);
        Criteria criteria = this.getDefaultCriteria(parameters).add((Criterion)equalsPkid);
        parameters.addTimespanTo(criteria);
        return criteria.list();
    }

    @Override
    protected String getDatasetProperty() {
        return "";
    }

    @Override
    protected Criteria getDefaultCriteria() {
        return this.getDefaultCriteria((DbQuery)null);
    }

    protected Criteria getDefaultCriteria(DbQuery parameters) {
        Criteria criteria = this.session.createCriteria(this.entityType).addOrder(Order.asc((String)COLUMN_TIMEEND)).add((Criterion)Restrictions.eq((String)COLUMN_DELETED, (Object)Boolean.FALSE));
        if (parameters != null && parameters.getResultTime() != null) {
            criteria = criteria.add((Criterion)Restrictions.eq((String)COLUMN_RESULTTIME, (Object)parameters.getResultTime()));
        }
        criteria = parameters != null && parameters.isComplexParent() ? criteria.add((Criterion)Restrictions.eq((String)COLUMN_PARENT, (Object)true)) : criteria.add((Criterion)Restrictions.eq((String)COLUMN_PARENT, (Object)false));
        return criteria;
    }

    @Override
    protected Class<T> getEntityClass() {
        return this.entityType;
    }

    public T getDataValueViaTimeend(DatasetEntity series, DbQuery query) {
        Date timeend = series.getLastValueAt();
        return this.getDataValueAt(timeend, COLUMN_TIMEEND, series, query);
    }

    public T getDataValueViaTimestart(DatasetEntity series, DbQuery query) {
        Date timestart = series.getFirstValueAt();
        return this.getDataValueAt(timestart, COLUMN_TIMESTART, series, query);
    }

    private T getDataValueAt(Date timestamp, String column, DatasetEntity series, DbQuery query) {
        LOGGER.debug("get instances @{} for '{}'", (Object)timestamp, (Object)series.getPkid());
        Criteria criteria = this.getDefaultCriteria(query).add((Criterion)Restrictions.eq((String)COLUMN_SERIES_PKID, (Object)series.getPkid())).add((Criterion)Restrictions.eq((String)column, (Object)timestamp));
        DetachedCriteria filter = DetachedCriteria.forClass(DatasetEntity.class).setProjection((Projection)Projections.projectionList().add((Projection)Projections.property((String)"pkid")));
        criteria.add(Subqueries.propertyIn((String)COLUMN_SERIES_PKID, (DetachedCriteria)filter));
        IoParameters parameters = query.getParameters();
        if (parameters.containsParameter(COLUMN_RESULTTIME)) {
            Instant resultTime = parameters.getResultTime();
            criteria.add((Criterion)Restrictions.eq((String)COLUMN_RESULTTIME, (Object)resultTime.toDate()));
            return (T)((DataEntity)criteria.uniqueResult());
        }
        List list = criteria.list();
        return this.getLastValueWhenMultipleResultTimesAvailable(list);
    }

    private T getLastValueWhenMultipleResultTimesAvailable(List<T> values) {
        DataEntity lastValue = null;
        for (DataEntity value : values) {
            lastValue = lastValue != null ? lastValue : value;
            Date lastResultTime = lastValue.getResultTime();
            Date resultTime = value.getResultTime();
            if (!new Instant((Object)resultTime).isAfter((ReadableInstant)new Instant((Object)lastResultTime))) continue;
            lastValue = value;
        }
        return (T)lastValue;
    }
}

