/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.I18nFeatureEntity;
import org.n52.series.db.beans.I18nOfferingEntity;
import org.n52.series.db.beans.I18nPhenomenonEntity;
import org.n52.series.db.beans.I18nProcedureEntity;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.QueryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DatasetDao<T extends DatasetEntity>
extends AbstractDao<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetDao.class);
    private static final String COLUMN_PKID = "pkid";
    private final Class<T> entityType;

    public DatasetDao(Session session, Class<T> clazz) {
        super(session);
        this.entityType = clazz;
    }

    public DatasetDao(Session session) {
        super(session);
        this.entityType = DatasetEntity.class;
    }

    @Override
    public List<T> find(DbQuery query) {
        LOGGER.debug("find entities: {}", (Object)query);
        ArrayList series = new ArrayList();
        String searchTerm = "%" + query.getSearchTerm() + "%";
        Criteria criteria = this.addIgnoreUnpublishedSeriesTo(this.getDefaultCriteria("s"), "s");
        Criteria featureCriteria = criteria.createCriteria("feature", JoinType.LEFT_OUTER_JOIN);
        featureCriteria = this.i18n(I18nFeatureEntity.class, featureCriteria, query);
        featureCriteria.add(Restrictions.ilike((String)"name", (Object)searchTerm));
        series.addAll(featureCriteria.list());
        Criteria procedureCriteria = criteria.createCriteria("procedure", JoinType.LEFT_OUTER_JOIN);
        procedureCriteria = this.i18n(I18nProcedureEntity.class, procedureCriteria, query);
        procedureCriteria.add(Restrictions.ilike((String)"name", (Object)searchTerm));
        series.addAll(procedureCriteria.list());
        Criteria offeringCriteria = criteria.createCriteria("offering", JoinType.LEFT_OUTER_JOIN);
        offeringCriteria = this.i18n(I18nOfferingEntity.class, offeringCriteria, query);
        offeringCriteria.add(Restrictions.ilike((String)"name", (Object)searchTerm));
        series.addAll(offeringCriteria.list());
        Criteria phenomenonCriteria = criteria.createCriteria("phenomenon", JoinType.LEFT_OUTER_JOIN);
        phenomenonCriteria = this.i18n(I18nPhenomenonEntity.class, phenomenonCriteria, query);
        phenomenonCriteria.add(Restrictions.ilike((String)"name", (Object)searchTerm));
        series.addAll(phenomenonCriteria.list());
        return series;
    }

    @Override
    public List<T> getAllInstances(DbQuery parameters) throws DataAccessException {
        LOGGER.debug("get all instances: {}", (Object)parameters);
        Criteria criteria = this.getDefaultCriteria();
        Criteria procedureCreateria = criteria.createCriteria("procedure");
        procedureCreateria.add((Criterion)Restrictions.eq((String)"reference", (Object)false));
        return parameters.addFilters(criteria, this.getDatasetProperty()).list();
    }

    public List<T> getInstancesWith(FeatureEntity feature) {
        LOGGER.debug("get instance for feature '{}'", (Object)feature);
        Criteria criteria = this.getDefaultCriteria().createCriteria("feature", JoinType.LEFT_OUTER_JOIN).add((Criterion)Restrictions.eq((String)COLUMN_PKID, (Object)feature.getPkid()));
        return criteria.list();
    }

    public List<T> getInstancesWith(PlatformEntity platform) {
        LOGGER.debug("get instance for platform '{}'", (Object)platform);
        Criteria criteria = this.getDefaultCriteria().createCriteria("procedure", JoinType.LEFT_OUTER_JOIN).add((Criterion)Restrictions.eq((String)COLUMN_PKID, (Object)platform.getPkid()));
        return criteria.list();
    }

    @Override
    protected Class<T> getEntityClass() {
        return this.entityType;
    }

    @Override
    protected String getDatasetProperty() {
        return "";
    }

    @Override
    protected Criteria getDefaultCriteria() {
        return this.getDefaultCriteria("dataset");
    }

    @Override
    protected Criteria getDefaultCriteria(String alias) {
        Criteria criteria = this.entityType != null ? super.getDefaultCriteria(alias) : this.session.createCriteria(DatasetEntity.class, alias);
        this.addIgnoreUnpublishedSeriesTo(criteria, alias);
        return criteria;
    }

    private Criteria addIgnoreUnpublishedSeriesTo(Criteria criteria, String alias) {
        criteria.add((Criterion)Restrictions.and((Criterion)this.createNotNullFirstLastValueRestriction(alias), (Criterion)this.createPublishedAndNotDeletedRestriction(alias)));
        return criteria;
    }

    private Criterion createPublishedAndNotDeletedRestriction(String alias) {
        return Restrictions.and((Criterion)Restrictions.eq((String)QueryUtils.createAssociation(alias, "published"), (Object)true), (Criterion)Restrictions.eqOrIsNull((String)QueryUtils.createAssociation(alias, "deleted"), (Object)false));
    }

    private LogicalExpression createNotNullFirstLastValueRestriction(String alias) {
        return Restrictions.and((Criterion)Restrictions.isNotNull((String)QueryUtils.createAssociation(alias, "firstValueAt")), (Criterion)Restrictions.isNotNull((String)QueryUtils.createAssociation(alias, "lastValueAt")));
    }
}

