/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.I18nFeatureEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FeatureDao
extends AbstractDao<FeatureEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureDao.class);

    public FeatureDao(Session session) {
        super(session);
    }

    @Override
    public List<FeatureEntity> find(DbQuery query) {
        LOGGER.debug("find instance: {}", (Object)query);
        Criteria criteria = this.i18n(I18nFeatureEntity.class, this.getDefaultCriteria(), query);
        criteria.add(Restrictions.ilike((String)"name", (Object)("%" + query.getSearchTerm() + "%")));
        return query.addFilters(criteria, this.getDatasetProperty()).list();
    }

    @Override
    public List<FeatureEntity> getAllInstances(DbQuery query) throws DataAccessException {
        LOGGER.debug("get all instances: {}", (Object)query);
        Criteria criteria = this.i18n(I18nFeatureEntity.class, this.getDefaultCriteria(), query);
        return query.addFilters(criteria, this.getDatasetProperty()).list();
    }

    @Override
    protected String getDatasetProperty() {
        return "feature";
    }

    @Override
    protected Class<FeatureEntity> getEntityClass() {
        return FeatureEntity.class;
    }
}

