/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.I18nPlatformEntity;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PlatformDao
extends AbstractDao<PlatformEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformDao.class);
    private static final String SERIES_PROPERTY = "platform";

    public PlatformDao(Session session) {
        super(session);
    }

    @Override
    public List<PlatformEntity> find(DbQuery query) {
        LOGGER.debug("find instance: {}", (Object)query);
        Criteria criteria = this.i18n(I18nPlatformEntity.class, this.getDefaultCriteria(), query);
        criteria.add(Restrictions.ilike((String)"name", (Object)("%" + query.getSearchTerm() + "%")));
        return query.addFilters(criteria, this.getDatasetProperty()).list();
    }

    @Override
    public List<PlatformEntity> getAllInstances(DbQuery query) throws DataAccessException {
        String seriesProperty = this.getDatasetProperty();
        Criteria criteria = this.i18n(I18nPlatformEntity.class, this.getDefaultCriteria(seriesProperty), query);
        return query.addFilters(criteria, seriesProperty).list();
    }

    @Override
    protected String getDatasetProperty() {
        return SERIES_PROPERTY;
    }

    @Override
    protected Class<PlatformEntity> getEntityClass() {
        return PlatformEntity.class;
    }
}

