/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.I18nProcedureEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ProcedureDao
extends AbstractDao<ProcedureEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcedureDao.class);
    private static final String COLUMN_REFERENCE = "reference";

    public ProcedureDao(Session session) {
        super(session);
    }

    @Override
    public List<ProcedureEntity> find(DbQuery query) {
        Criteria criteria = this.i18n(I18nProcedureEntity.class, this.getDefaultCriteria(true), query);
        criteria.add(Restrictions.ilike((String)"name", (Object)("%" + query.getSearchTerm() + "%")));
        return query.addFilters(criteria, this.getDatasetProperty()).list();
    }

    @Override
    public List<ProcedureEntity> getAllInstances(DbQuery query) throws DataAccessException {
        Criteria criteria = this.i18n(I18nProcedureEntity.class, this.getDefaultCriteria(true), query);
        return query.addFilters(criteria, this.getDatasetProperty()).list();
    }

    @Override
    public ProcedureEntity getInstance(Long key, DbQuery parameters) throws DataAccessException {
        LOGGER.debug("get instance '{}': {}", (Object)key, (Object)parameters);
        Criteria criteria = this.getDefaultCriteria(true);
        return this.getEntityClass().cast(criteria.add((Criterion)Restrictions.eq((String)"pkid", (Object)key)).uniqueResult());
    }

    @Override
    protected Criteria getDefaultCriteria() {
        return this.getDefaultCriteria(true);
    }

    private Criteria getDefaultCriteria(boolean ignoreReferenceProcedures) {
        return ignoreReferenceProcedures ? super.getDefaultCriteria().add((Criterion)Restrictions.eq((String)COLUMN_REFERENCE, (Object)Boolean.FALSE)) : super.getDefaultCriteria();
    }

    @Override
    protected String getDatasetProperty() {
        return "procedure";
    }

    @Override
    protected Class<ProcedureEntity> getEntityClass() {
        return ProcedureEntity.class;
    }
}

