/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.srv;

import java.util.ArrayList;
import java.util.Collection;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;
import org.n52.io.response.CategoryOutput;
import org.n52.io.response.FeatureOutput;
import org.n52.io.response.PhenomenonOutput;
import org.n52.io.response.PlatformOutput;
import org.n52.io.response.ProcedureOutput;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.StationOutput;
import org.n52.io.response.dataset.TimeseriesMetadataOutput;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.spi.search.SearchResult;
import org.n52.series.spi.search.SearchService;
import org.springframework.beans.factory.annotation.Autowired;

public class Search
implements SearchService {
    @Autowired
    private OutputAssembler<ProcedureOutput> procedureRepository;
    @Autowired
    private OutputAssembler<PhenomenonOutput> phenomenonRepository;
    @Autowired
    private OutputAssembler<FeatureOutput> featureRepository;
    @Autowired
    private OutputAssembler<CategoryOutput> categoryRepository;
    @Autowired
    private OutputAssembler<PlatformOutput> platformRepository;
    @Autowired
    private OutputAssembler<DatasetOutput<?, ?>> datasetRepository;
    @Autowired
    @Deprecated
    private OutputAssembler<TimeseriesMetadataOutput> timeseriesRepository;
    @Autowired
    @Deprecated
    private OutputAssembler<StationOutput> stationRepository;

    public Collection<SearchResult> searchResources(IoParameters parameters) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        results.addAll(this.phenomenonRepository.searchFor(parameters));
        results.addAll(this.procedureRepository.searchFor(parameters));
        results.addAll(this.featureRepository.searchFor(parameters));
        results.addAll(this.categoryRepository.searchFor(parameters));
        results.addAll(this.platformRepository.searchFor(parameters));
        results.addAll(this.datasetRepository.searchFor(parameters));
        FilterResolver filterResolver = new FilterResolver(parameters);
        if (filterResolver.shallBehaveBackwardsCompatible()) {
            results.addAll(this.timeseriesRepository.searchFor(parameters));
            results.addAll(this.stationRepository.searchFor(parameters));
        }
        return results;
    }
}

