/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataRepositoryComponent;
import org.n52.series.db.DataRepositoryTypeFactory;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.da.DataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class AnnotationBasedDataRepositoryFactory
implements DataRepositoryTypeFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationBasedDataRepositoryFactory.class);
    private final Map<String, ? super DataRepository<?, ?, ?, ?>> cache = new HashMap();
    @Autowired
    private ApplicationContext appContext;

    private Stream<DataRepository<? extends DatasetEntity, ? extends DataEntity<?>, ? extends AbstractValue<?>, ?>> getAllDataAssemblers() {
        Map beansWithAnnotation = this.appContext.getBeansWithAnnotation(DataRepositoryComponent.class);
        Collection dataAssembleTypes = beansWithAnnotation.values();
        LOGGER.debug("Found following " + DataRepositoryComponent.class.getSimpleName() + ": {}", (Object)dataAssembleTypes.stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", ")));
        return dataAssembleTypes.stream().filter(DataRepository.class::isInstance).map(DataRepository.class::cast);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isKnown(String valueType) {
        if (this.hasCacheEntry(valueType)) return true;
        if (!this.getAllDataAssemblers().map(this::getDataType).filter(valueType::equals).findFirst().isPresent()) return false;
        return true;
    }

    private Optional<DataRepository<? extends DatasetEntity, ? extends DataEntity<?>, ? extends AbstractValue<?>, ?>> findDataAssembler(String type) {
        return this.getAllDataAssemblers().filter(it -> this.getDataType((DataRepository<? extends DatasetEntity, ? extends DataEntity<?>, ? extends AbstractValue<?>, ?>)it).equals(type)).findFirst();
    }

    @Override
    public Set<String> getKnownTypes() {
        return this.getAllDataAssemblers().map(this::getDataType).collect(Collectors.toSet());
    }

    private String getDataType(DataRepository<? extends DatasetEntity, ? extends DataEntity<?>, ? extends AbstractValue<?>, ?> assembler) {
        return assembler.getClass().getAnnotation(DataRepositoryComponent.class).value();
    }

    @Override
    public <S extends DatasetEntity, E extends DataEntity<T>, V extends AbstractValue<?>, T> DataRepository<S, E, V, T> create(String type, Class<S> entityType) {
        return this.addToCache(type, this.findDataAssembler(type).orElseThrow(this.throwException(type)));
    }

    private <A extends DataRepository<? extends DatasetEntity, ? extends DataEntity<?>, ? extends AbstractValue<?>, ?>> A addToCache(String valueType, A assembler) {
        this.cache.put(valueType, assembler);
        return assembler;
    }

    private Supplier<? extends DataAccessException> throwException(String type) {
        return () -> new DataAccessException("Unknown type: " + type);
    }

    @Override
    public Class<? extends DatasetEntity> getDatasetEntityType(String valueType) {
        return this.findDataAssembler(valueType).map(Object::getClass).map(c -> c.getAnnotation(DataRepositoryComponent.class)).map(DataRepositoryComponent::datasetEntityType).get();
    }

    @Override
    public boolean hasCacheEntry(String valueType) {
        return this.cache.containsKey(valueType);
    }
}

