/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTime;
import org.junit.Test;
import org.n52.series.db.beans.DataEntity;

public class DataEntityTest {
    @Test
    public void when_settingTimestartWithNanos_then_nanosAvailableOnGetting() {
        DataEntity<Object> dataEntity = this.createDataDummy();
        Timestamp timestamp = this.createTimestamp("2015-07-17T21:14:35.022+02", 321);
        dataEntity.setTimestart((Date)timestamp);
        Timestamp timestart = (Timestamp)dataEntity.getTimestart();
        MatcherAssert.assertThat((Object)timestart.getNanos(), (Matcher)CoreMatchers.is((Object)timestamp.getNanos()));
    }

    @Test
    public void when_settingTimeendWithNanos_then_nanosAvailableOnGetting() {
        DataEntity<Object> dataEntity = this.createDataDummy();
        Timestamp timestamp = this.createTimestamp("2015-07-17T21:14:35.022+02", 321);
        dataEntity.setTimeend((Date)timestamp);
        Timestamp timeend = (Timestamp)dataEntity.getTimeend();
        MatcherAssert.assertThat((Object)timeend.getNanos(), (Matcher)CoreMatchers.is((Object)timestamp.getNanos()));
    }

    @Test
    public void when_settingResulttimeWithNanos_then_nanosAvailableOnGetting() {
        DataEntity<Object> dataEntity = this.createDataDummy();
        Timestamp timestamp = this.createTimestamp("2015-07-17T21:14:35.022+02", 321);
        dataEntity.setResultTime((Date)timestamp);
        Timestamp resulttime = (Timestamp)dataEntity.getResultTime();
        MatcherAssert.assertThat((Object)resulttime.getNanos(), (Matcher)CoreMatchers.is((Object)timestamp.getNanos()));
    }

    @Test
    public void when_settingTimestampWithNanos_then_nanosAvailableOnGetting() {
        DataEntity<Object> dataEntity = this.createDataDummy();
        Timestamp timestamp = this.createTimestamp("2015-07-17T21:14:35.022+02", 321);
        dataEntity.setTimestamp((Date)timestamp);
        Timestamp timestamp2 = (Timestamp)dataEntity.getTimestamp();
        MatcherAssert.assertThat((Object)timestamp2.getNanos(), (Matcher)CoreMatchers.is((Object)timestamp.getNanos()));
    }

    @Test
    public void when_settingValidTimeStartWithNanos_then_nanosAvailableOnGetting() {
        DataEntity<Object> dataEntity = this.createDataDummy();
        Timestamp timestamp = this.createTimestamp("2015-07-17T21:14:35.022+02", 321);
        dataEntity.setValidTimeStart((Date)timestamp);
        Timestamp validTimestart = (Timestamp)dataEntity.getValidTimeStart();
        MatcherAssert.assertThat((Object)validTimestart.getNanos(), (Matcher)CoreMatchers.is((Object)timestamp.getNanos()));
    }

    @Test
    public void when_settingValidTimeEndWithNanos_then_nanosAvailableOnGetting() {
        DataEntity<Object> dataEntity = this.createDataDummy();
        Timestamp timestamp = this.createTimestamp("2015-07-17T21:14:35.022+02", 321);
        dataEntity.setValidTimeEnd((Date)timestamp);
        Timestamp validTimeend = (Timestamp)dataEntity.getValidTimeEnd();
        MatcherAssert.assertThat((Object)validTimeend.getNanos(), (Matcher)CoreMatchers.is((Object)timestamp.getNanos()));
    }

    @Test
    public void when_settingTimestamp_then_timeendIsSet() {
        DataEntity<Object> dataEntity = this.createDataDummy();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        dataEntity.setTimestamp((Date)now);
        Timestamp timeend = (Timestamp)dataEntity.getTimeend();
        MatcherAssert.assertThat((Object)timeend, (Matcher)CoreMatchers.is((Object)now));
    }

    private DataEntity<Object> createDataDummy() {
        DataEntity<Object> dataEntity = new DataEntity<Object>(){

            public boolean isNoDataValue(Collection<String> noDataValues) {
                return false;
            }
        };
        return dataEntity;
    }

    private Timestamp createTimestamp(String date, int nanos) {
        DateTime timeValue = DateTime.parse((String)date);
        Timestamp timestamp = new Timestamp(timeValue.getMillis());
        timestamp.setNanos(nanos);
        return timestamp;
    }
}

