/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.n52.series.db.beans.I18nEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.parameter.Parameter;

public class DescribableEntity {
    public static final String PROPERTY_PKID = "pkid";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_DOMAIN_ID = "domainId";
    @Deprecated
    public static final String PROPERTY_SERVICE_ID = "serviceid";
    public static final String PROPERTY_SERVICE = "service";
    private Long pkid;
    private String domainId;
    private String name;
    private String description;
    private ServiceEntity service;
    private Set<I18nEntity> translations;
    private Set<Parameter<?>> parameters;

    public Long getPkid() {
        return this.pkid;
    }

    public void setPkid(Long pkid) {
        this.pkid = pkid;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSetName() {
        return this.getName() != null && !this.getName().isEmpty();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isSetDescription() {
        return this.getDescription() != null && !this.getDescription().isEmpty();
    }

    public Set<I18nEntity> getTranslations() {
        return this.translations;
    }

    public void setTranslations(Set<I18nEntity> translations) {
        this.translations = translations;
    }

    public Set<Parameter<?>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Set<Parameter<?>> parameters) {
        this.parameters = parameters;
    }

    public boolean hasParameters() {
        return this.getParameters() != null && !this.getParameters().isEmpty();
    }

    public Set<Map<String, Object>> getMappedParameters(String locale) {
        return this.hasParameters() ? this.parameters.stream().map(e -> e.toValueMap(locale)).collect(Collectors.toSet()) : null;
    }

    public ServiceEntity getService() {
        return this.service;
    }

    public void setService(ServiceEntity service) {
        this.service = service;
    }

    public String getNameI18n(String locale) {
        if (this.noTranslationAvailable(locale)) {
            return this.name;
        }
        String candidate = this.name;
        String countryCode = this.getCountryCode(locale);
        for (I18nEntity translation : this.translations) {
            String translatedLocale = translation.getLocale();
            if (translatedLocale.equals(locale)) {
                return translation.getName();
            }
            if (!translatedLocale.equals(countryCode)) continue;
            candidate = translation.getName();
        }
        return candidate;
    }

    public String getLabelFrom(String locale) {
        if (this.isi18nNameAvailable(locale)) {
            return this.getNameI18n(locale);
        }
        if (this.isNameAvailable()) {
            return this.getName();
        }
        if (this.isDomainIdAvailable()) {
            return this.getDomainId();
        }
        return Long.toString(this.getPkid());
    }

    private boolean isNameAvailable() {
        return this.getName() != null && !this.getName().isEmpty();
    }

    private boolean isDomainIdAvailable() {
        return this.getDomainId() != null && !this.getDomainId().isEmpty();
    }

    private boolean isi18nNameAvailable(String locale) {
        return this.getNameI18n(locale) != null && !this.getNameI18n(locale).isEmpty();
    }

    private boolean noTranslationAvailable(String locale) {
        return this.translations == null || locale == null || this.translations.isEmpty() || locale.isEmpty();
    }

    private String getCountryCode(String locale) {
        return locale.split("_")[0];
    }
}

