/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.HrefHelper;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.PlatformOutput;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.DatasetParameters;
import org.n52.io.response.dataset.ReferenceValueOutput;
import org.n52.io.response.dataset.ValueType;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataRepositoryTypeFactory;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.PlatformRepository;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.spi.search.DatasetSearchResult;
import org.n52.series.spi.search.SearchResult;
import org.n52.web.exception.BadQueryParameterException;
import org.n52.web.exception.ResourceNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;

public class DatasetRepository<V extends AbstractValue<?>>
extends SessionAwareRepository
implements OutputAssembler<DatasetOutput<V>> {
    @Autowired
    private DataRepositoryTypeFactory dataRepositoryFactory;
    @Autowired
    private PlatformRepository platformRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery query) {
        Session session = this.getSession();
        try {
            String dbId = ValueType.extractId((String)id);
            String handleAsFallback = query.getHandleAsValueTypeFallback();
            String valueType = ValueType.extractType((String)id, (String)handleAsFallback);
            if (!this.dataRepositoryFactory.isKnown(valueType)) {
                boolean bl = false;
                return bl;
            }
            DatasetDao<DatasetEntity> dao = this.getDatasetDao(valueType, session);
            Class<? extends DatasetEntity> datasetEntityType = this.dataRepositoryFactory.getDatasetEntityType(valueType);
            IoParameters parameters = query.getParameters();
            boolean bl = parameters.isMatchDomainIds() ? dao.hasInstance(dbId, query, datasetEntityType) : dao.hasInstance(this.parseId(dbId), query, datasetEntityType);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DatasetOutput<V>> getAllCondensed(DbQuery query) {
        Session session = this.getSession();
        try {
            List<DatasetOutput<V>> list = this.getAllCondensed(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<DatasetOutput<V>> getAllCondensed(DbQuery query, Session session) {
        ArrayList<DatasetOutput<V>> results = new ArrayList<DatasetOutput<V>>();
        FilterResolver filterResolver = query.getFilterResolver();
        if (query.getParameters().isMatchDomainIds()) {
            String valueType = query.getHandleAsValueTypeFallback();
            this.addCondensedResults(this.getDatasetDao(valueType, session), query, results, session);
            return results;
        }
        if (filterResolver.shallIncludeAllDatasetTypes()) {
            this.addCondensedResults(this.getDatasetDao(DatasetEntity.class, session), query, results, session);
        } else {
            for (String valueType : query.getValueTypes()) {
                this.addCondensedResults(this.getDatasetDao(valueType, session), query, results, session);
            }
        }
        return results;
    }

    private void addCondensedResults(DatasetDao<? extends DatasetEntity> dao, DbQuery query, List<DatasetOutput<V>> results, Session session) {
        for (DatasetEntity datasetEntity : dao.getAllInstances(query)) {
            if (!this.dataRepositoryFactory.isKnown(datasetEntity.getValueType())) continue;
            results.add(this.createCondensed(datasetEntity, query, session));
        }
    }

    private DatasetDao<? extends DatasetEntity> getDatasetDao(Class<? extends DatasetEntity> clazz, Session session) {
        return new DatasetDao<DatasetEntity>(session, clazz);
    }

    private DatasetDao<? extends DatasetEntity> getDatasetDao(String valueType, Session session) {
        if (!"all".equalsIgnoreCase(valueType) && !this.dataRepositoryFactory.isKnown(valueType)) {
            throw new BadQueryParameterException("invalid type: " + valueType);
        }
        return this.createDataAccessRepository(valueType, session);
    }

    private DatasetDao<? extends DatasetEntity> getSeriesDao(String datasetId, DbQuery query, Session session) throws DataAccessException {
        String handleAsFallback = query.getHandleAsValueTypeFallback();
        String valueType = ValueType.extractType((String)datasetId, (String)handleAsFallback);
        if (!this.dataRepositoryFactory.isKnown(valueType)) {
            throw new ResourceNotFoundException("unknown type: " + valueType);
        }
        return this.createDataAccessRepository(valueType, session);
    }

    private DatasetDao<? extends DatasetEntity> createDataAccessRepository(String valueType, Session session) {
        return this.getDatasetDao(this.dataRepositoryFactory.getDatasetEntityType(valueType), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DatasetOutput<V>> getAllExpanded(DbQuery query) {
        Session session = this.getSession();
        try {
            List<DatasetOutput<V>> list = this.getAllExpanded(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<DatasetOutput<V>> getAllExpanded(DbQuery query, Session session) {
        ArrayList<DatasetOutput<V>> results = new ArrayList<DatasetOutput<V>>();
        FilterResolver filterResolver = query.getFilterResolver();
        if (query.getParameters().isMatchDomainIds()) {
            String valueType = query.getHandleAsValueTypeFallback();
            this.addExpandedResults(this.getDatasetDao(valueType, session), query, results, session);
            return results;
        }
        if (filterResolver.shallIncludeAllDatasetTypes()) {
            this.addExpandedResults(this.getDatasetDao(DatasetEntity.class, session), query, results, session);
        } else {
            for (String valueType : query.getValueTypes()) {
                this.addExpandedResults(this.getDatasetDao(valueType, session), query, results, session);
            }
        }
        return results;
    }

    private void addExpandedResults(DatasetDao<? extends DatasetEntity> dao, DbQuery query, List<DatasetOutput<V>> results, Session session) {
        for (DatasetEntity datasetEntity : dao.getAllInstances(query)) {
            if (!this.dataRepositoryFactory.isKnown(datasetEntity.getValueType())) continue;
            results.add(this.createExpanded(datasetEntity, query, session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetOutput<V> getInstance(String id, DbQuery query) {
        Session session = this.getSession();
        try {
            DatasetOutput<V> datasetOutput = this.getInstance(id, query, session);
            return datasetOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public DatasetOutput<V> getInstance(String id, DbQuery query, Session session) {
        DatasetEntity instanceEntity = this.getInstanceEntity(id, query, session);
        return this.createExpanded(instanceEntity, query, session);
    }

    DatasetEntity getInstanceEntity(String id, DbQuery query, Session session) {
        String rawId = ValueType.extractId((String)id);
        DatasetDao<DatasetEntity> dao = this.getSeriesDao(id, query, session);
        Object instance = dao.getInstance(Long.parseLong(rawId), query);
        ((DatasetEntity)instance).setPlatform(this.platformRepository.getPlatformEntity((DatasetEntity)instance, query, session));
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters paramters) {
        Session session = this.getSession();
        try {
            DatasetDao<DatasetEntity> dao = this.getDatasetDao(DatasetEntity.class, session);
            DbQuery query = this.getDbQuery(paramters);
            List<DatasetEntity> found = dao.find(query);
            List<SearchResult> list = this.convertToSearchResults(found, query);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    public List<SearchResult> convertToSearchResults(List<? extends DescribableEntity> found, DbQuery query) {
        String locale = query.getLocale();
        String hrefBase = HrefHelper.constructHref((String)query.getHrefBase(), (String)"datasets");
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (DescribableEntity describableEntity : found) {
            String pkid = describableEntity.getPkid().toString();
            String label = describableEntity.getLabelFrom(locale);
            results.add((SearchResult)new DatasetSearchResult(pkid, label, hrefBase));
        }
        return results;
    }

    protected DatasetOutput<V> createCondensed(DatasetEntity dataset, DbQuery query, Session session) {
        IoParameters parameters = query.getParameters();
        String valueType = dataset.getValueType();
        DatasetOutput result = DatasetOutput.create((String)valueType, (IoParameters)parameters);
        Long id = dataset.getPkid();
        String hrefBase = query.getHrefBase();
        String domainId = dataset.getDomainId();
        String uom = dataset.getUnitI18nName(query.getLocale());
        String label = this.createDatasetLabel(dataset, query.getLocale());
        String platformtype = this.getCondensedPlatform(dataset, query.withoutFieldsFilter(), session).getPlatformType();
        result.setId(id.toString());
        result.setValue("uom", (Object)uom, parameters, arg_0 -> ((DatasetOutput)result).setUom(arg_0));
        result.setValue("label", (Object)label, parameters, arg_0 -> ((DatasetOutput)result).setLabel(arg_0));
        result.setValue("domainId", (Object)domainId, parameters, arg_0 -> ((DatasetOutput)result).setDomainId(arg_0));
        result.setValue("href", (Object)hrefBase, parameters, arg_0 -> ((DatasetOutput)result).setHrefBase(arg_0));
        result.setValue("platformType", (Object)platformtype, parameters, arg_0 -> ((DatasetOutput)result).setPlatformType(arg_0));
        return result;
    }

    protected DatasetOutput<V> createExpanded(DatasetEntity dataset, DbQuery query, Session session) {
        IoParameters params = query.getParameters();
        DatasetOutput<V> result = this.createCondensed(dataset, query, session);
        DatasetParameters datasetParams = this.createDatasetParameters(dataset, query.withoutFieldsFilter(), session);
        datasetParams.setPlatform((ParameterOutput)this.getCondensedPlatform(dataset, query, session));
        if (dataset.getService() == null) {
            dataset.setService(this.getServiceEntity());
        }
        DataRepository<DatasetEntity, ?, V, ?> dataRepository = this.getDataRepositoryFactory(dataset);
        V firstValue = dataRepository.getFirstValue(dataset, session, query);
        V lastValue = dataset.getFirstValueAt().equals(dataset.getLastValueAt()) ? firstValue : dataRepository.getLastValue(dataset, session, query);
        List<ReferenceValueOutput<V>> refValues = dataRepository.getReferenceValues(dataset, query);
        lastValue = this.isReferenceSeries(dataset) && this.isCongruentValues((AbstractValue<?>)firstValue, (AbstractValue<?>)lastValue) ? firstValue : lastValue;
        result.setValue("referenceValues", refValues, params, arg_0 -> result.setReferenceValues(arg_0));
        result.setValue("parameters", (Object)datasetParams, params, arg_0 -> result.setDatasetParameters(arg_0));
        result.setValue("firstValue", firstValue, params, arg_0 -> result.setFirstValue(arg_0));
        result.setValue("lastValue", lastValue, params, arg_0 -> result.setLastValue(arg_0));
        return result;
    }

    private DataRepository<DatasetEntity, ?, V, ?> getDataRepositoryFactory(DatasetEntity dataset) {
        return this.dataRepositoryFactory.create(dataset.getValueType(), DatasetEntity.class);
    }

    private boolean isCongruentValues(AbstractValue<?> firstValue, AbstractValue<?> lastValue) {
        return firstValue.getTimestamp().equals(lastValue.getTimestamp());
    }

    private boolean isReferenceSeries(DatasetEntity series) {
        return series.getProcedure().isReference();
    }

    private PlatformOutput getCondensedPlatform(DatasetEntity dataset, DbQuery query, Session session) {
        return this.platformRepository.createCondensedPlatform(dataset, query, session);
    }

    private String createDatasetLabel(DatasetEntity dataset, String locale) {
        PhenomenonEntity phenomenon = dataset.getPhenomenon();
        ProcedureEntity procedure = dataset.getProcedure();
        OfferingEntity offering = dataset.getOffering();
        FeatureEntity feature = dataset.getFeature();
        String procedureLabel = procedure.getLabelFrom(locale);
        String phenomenonLabel = phenomenon.getLabelFrom(locale);
        String offeringLabel = offering.getLabelFrom(locale);
        String stationLabel = feature.getLabelFrom(locale);
        StringBuilder sb = new StringBuilder();
        return sb.append(phenomenonLabel).append(" ").append(procedureLabel).append(", ").append(stationLabel).append(", ").append(offeringLabel).toString();
    }

    public DataRepositoryTypeFactory getDataRepositoryTypeFactory() {
        return this.dataRepositoryFactory;
    }

    public void setDataRepositoryTypeFactory(DataRepositoryTypeFactory dataRepositoryTypeFactory) {
        this.dataRepositoryFactory = dataRepositoryTypeFactory;
    }
}

