/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DatasetMetadata;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.ReferenceValueOutput;
import org.n52.io.response.dataset.quantity.QuantityValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataRepositoryComponent;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.QuantityDatasetEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

@DataRepositoryComponent(value="quantity", datasetEntityType=QuantityDatasetEntity.class)
public class QuantityDataRepository
extends AbstractDataRepository<QuantityDatasetEntity, QuantityDataEntity, QuantityValue, BigDecimal> {
    @Override
    public List<ReferenceValueOutput<QuantityValue>> getReferenceValues(QuantityDatasetEntity datasetEntity, DbQuery query) {
        return datasetEntity.getReferenceValues().stream().map(referenceSeriesEntity -> {
            ReferenceValueOutput refenceValueOutput = new ReferenceValueOutput();
            ProcedureEntity procedure = referenceSeriesEntity.getProcedure();
            refenceValueOutput.setLabel(procedure.getNameI18n(query.getLocale()));
            refenceValueOutput.setReferenceValueId(this.createReferenceDatasetId(query, (QuantityDatasetEntity)referenceSeriesEntity));
            QuantityDataEntity lastValue = (QuantityDataEntity)referenceSeriesEntity.getLastValue();
            refenceValueOutput.setLastValue((AbstractValue)this.assembleDataValue(lastValue, (QuantityDatasetEntity)referenceSeriesEntity, query));
            return refenceValueOutput;
        }).collect(Collectors.toList());
    }

    @Override
    protected Data<QuantityValue> assembleExpandedData(QuantityDatasetEntity dataset, DbQuery query, Session session) throws DataAccessException {
        Data<QuantityValue> result = this.assembleData(dataset, query, session);
        DatasetMetadata metadata = result.getMetadata();
        if (metadata == null) {
            metadata = new DatasetMetadata();
            result.setMetadata(metadata);
        }
        QuantityDataEntity previousValue = (QuantityDataEntity)this.getClosestValueBeforeStart(dataset, query);
        QuantityDataEntity nextValue = (QuantityDataEntity)this.getClosestValueAfterEnd(dataset, query);
        metadata.setValueBeforeTimespan((AbstractValue)this.createValue(previousValue, dataset, query));
        metadata.setValueAfterTimespan((AbstractValue)this.createValue(nextValue, dataset, query));
        List<QuantityDatasetEntity> referenceValues = dataset.getReferenceValues();
        if (referenceValues != null && !referenceValues.isEmpty()) {
            metadata.setReferenceValues(this.assembleReferenceSeries(referenceValues, query, session));
        }
        return result;
    }

    private Map<String, Data<QuantityValue>> assembleReferenceSeries(List<QuantityDatasetEntity> referenceValues, DbQuery query, Session session) throws DataAccessException {
        return referenceValues.stream().filter(DatasetEntity::isPublished).collect(Collectors.toMap(dataset -> this.createReferenceDatasetId(query, (QuantityDatasetEntity)dataset), dataset -> {
            Data<QuantityValue> data = this.assembleData((QuantityDatasetEntity)dataset, query, session);
            return this.haveToExpandReferenceData(data) ? this.expandReferenceDataIfNecessary((QuantityDatasetEntity)dataset, query, session) : data;
        }));
    }

    protected String createReferenceDatasetId(DbQuery query, QuantityDatasetEntity referenceSeriesEntity) {
        String valueType = referenceSeriesEntity.getValueType();
        DatasetOutput dataset = DatasetOutput.create((String)valueType, (IoParameters)query.getParameters());
        Long id = referenceSeriesEntity.getPkid();
        dataset.setId(id.toString());
        return dataset.getId();
    }

    private boolean haveToExpandReferenceData(Data<QuantityValue> referenceSeriesData) {
        return referenceSeriesData.getValues().size() <= 1;
    }

    private Data<QuantityValue> expandReferenceDataIfNecessary(QuantityDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        Data result = new Data();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor(seriesEntity, query);
        if (!this.hasValidEntriesWithinRequestedTimespan(observations)) {
            QuantityValue lastValue = (QuantityValue)this.getLastValue(seriesEntity, session, query);
            result.addValues((AbstractValue[])this.expandToInterval((BigDecimal)lastValue.getValue(), seriesEntity, query));
        }
        if (this.hasSingleValidReferenceValue(observations)) {
            QuantityDataEntity entity = (QuantityDataEntity)observations.get(0);
            result.addValues((AbstractValue[])this.expandToInterval((BigDecimal)entity.getValue(), seriesEntity, query));
        }
        return result;
    }

    @Override
    protected Data<QuantityValue> assembleData(QuantityDatasetEntity seriesEntity, DbQuery query, Session session) {
        Data result = new Data(new DatasetMetadata());
        this.createDataDao(session).getAllInstancesFor(seriesEntity, query).stream().filter(Objects::nonNull).map(observation -> this.assembleDataValue((QuantityDataEntity)observation, seriesEntity, query)).forEachOrdered(arg_0 -> ((Data)result).addNewValue(arg_0));
        return result;
    }

    private QuantityValue[] expandToInterval(BigDecimal value, QuantityDatasetEntity series, DbQuery query) {
        QuantityDataEntity referenceStart = new QuantityDataEntity();
        Date startDate = query.getTimespan().getStart().toDate();
        referenceStart.setTimestart(startDate);
        referenceStart.setTimeend(startDate);
        referenceStart.setValue(value);
        Date endDate = query.getTimespan().getEnd().toDate();
        QuantityDataEntity referenceEnd = new QuantityDataEntity();
        referenceEnd.setTimestart(endDate);
        referenceEnd.setTimeend(endDate);
        referenceEnd.setValue(value);
        return new QuantityValue[]{this.assembleDataValue(referenceStart, series, query), this.assembleDataValue(referenceEnd, series, query)};
    }

    @Override
    public QuantityValue assembleDataValue(QuantityDataEntity observation, QuantityDatasetEntity dataset, DbQuery query) {
        QuantityValue value = this.createValue(observation, dataset, query);
        return this.addMetadatasIfNeeded(observation, value, dataset, query);
    }

    private QuantityValue createValue(QuantityDataEntity observation, QuantityDatasetEntity dataset, DbQuery query) {
        return this.getServiceEntity(dataset).isNoDataValue(observation) ? null : this.createValue(this.format(observation, dataset), observation, query);
    }

    QuantityValue createValue(BigDecimal observationValue, QuantityDataEntity observation, DbQuery query) {
        Date timeend = observation.getTimeend();
        Date timestart = observation.getTimestart();
        long end = timeend.getTime();
        long start = timestart.getTime();
        return query.getParameters().isShowTimeIntervals() ? new QuantityValue(Long.valueOf(start), Long.valueOf(end), observationValue) : new QuantityValue(Long.valueOf(end), observationValue);
    }

    private BigDecimal format(QuantityDataEntity observation, QuantityDatasetEntity series) {
        return Optional.ofNullable(observation).map(DataEntity::getValue).map(v -> v.setScale(series.getNumberOfDecimals(), RoundingMode.HALF_UP)).orElse(null);
    }
}

