/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;

public final class JTSGeometryConverter {
    private static final String POINT = "Point";
    private static final String MULTI_POINT = "MultiPoint";
    private static final String LINE_STRING = "LineString";
    private static final String MULTI_LINE_STRING = "MultiLineString";
    private static final String MULTI_POLYGON = "MultiPolygon";
    private static final String POLYGON = "Polygon";
    private static final String GEOMETRY_COLLECTION = "GeometryCollection";
    private static final VS2LT VS2LT_CONVERTER = new VS2LT();
    private static final LT2VS LT2VS_CONVERTER = new LT2VS();

    private JTSGeometryConverter() {
    }

    public static Geometry convert(com.vividsolutions.jts.geom.Geometry geometry) {
        return VS2LT_CONVERTER.convert(geometry);
    }

    public static com.vividsolutions.jts.geom.Geometry convert(Geometry geometry) {
        return LT2VS_CONVERTER.convert(geometry);
    }

    private static final class VS2LT {
        private VS2LT() {
        }

        Geometry convert(com.vividsolutions.jts.geom.Geometry geometry) {
            if (geometry == null) {
                return null;
            }
            GeometryFactory factory = this.convertFactory(geometry.getFactory());
            switch (geometry.getGeometryType()) {
                case "Point": {
                    return factory.createPoint(this.convertCoordinate(geometry.getCoordinate()));
                }
                case "LineString": {
                    return factory.createLineString(this.convertCoordinates(geometry.getCoordinates()));
                }
                case "Polygon": {
                    com.vividsolutions.jts.geom.Polygon p = (com.vividsolutions.jts.geom.Polygon)geometry;
                    int n = p.getNumInteriorRing();
                    org.locationtech.jts.geom.LinearRing[] holes = new org.locationtech.jts.geom.LinearRing[n];
                    for (int i = 0; i < n; ++i) {
                        holes[i] = this.createLinearRing(factory, p.getInteriorRingN(i));
                    }
                    return factory.createPolygon(this.createLinearRing(factory, p.getExteriorRing()), holes);
                }
                case "MultiPoint": 
                case "MultiLineString": 
                case "MultiPolygon": 
                case "GeometryCollection": {
                    int n = geometry.getNumGeometries();
                    ArrayList<Geometry> array = new ArrayList<Geometry>(n);
                    for (int i = 0; i < n; ++i) {
                        array.add(this.convert(geometry.getGeometryN(i)));
                    }
                    return factory.buildGeometry(array);
                }
            }
            throw new IllegalArgumentException("Unsupported ol geometry: " + geometry);
        }

        private GeometryFactory convertFactory(com.vividsolutions.jts.geom.GeometryFactory factory) {
            return new GeometryFactory(this.convertPrecisionModel(factory.getPrecisionModel()), factory.getSRID());
        }

        private org.locationtech.jts.geom.PrecisionModel convertPrecisionModel(PrecisionModel precisionModel) {
            if (precisionModel.getType() == PrecisionModel.FIXED) {
                return new org.locationtech.jts.geom.PrecisionModel(precisionModel.getScale());
            }
            if (precisionModel.getType() == PrecisionModel.FLOATING) {
                return new org.locationtech.jts.geom.PrecisionModel(org.locationtech.jts.geom.PrecisionModel.FLOATING);
            }
            if (precisionModel.getType() == PrecisionModel.FLOATING_SINGLE) {
                return new org.locationtech.jts.geom.PrecisionModel(org.locationtech.jts.geom.PrecisionModel.FLOATING_SINGLE);
            }
            return new org.locationtech.jts.geom.PrecisionModel(new PrecisionModel.Type(precisionModel.getType().toString()));
        }

        private Coordinate convertCoordinate(com.vividsolutions.jts.geom.Coordinate coordinate) {
            return new Coordinate(coordinate.x, coordinate.y, coordinate.z);
        }

        private Coordinate[] convertCoordinates(com.vividsolutions.jts.geom.Coordinate[] coordinates) {
            int n = coordinates.length;
            Coordinate[] array = new Coordinate[n];
            for (int i = 0; i < n; ++i) {
                array[i] = this.convertCoordinate(coordinates[i]);
            }
            return array;
        }

        private org.locationtech.jts.geom.LinearRing createLinearRing(GeometryFactory factory, LineString geometry) {
            return factory.createLinearRing(this.convertCoordinates(geometry.getCoordinates()));
        }
    }

    private static final class LT2VS {
        private LT2VS() {
        }

        com.vividsolutions.jts.geom.Geometry convert(Geometry geometry) {
            if (geometry == null) {
                return null;
            }
            com.vividsolutions.jts.geom.GeometryFactory factory = this.convertFactory(geometry.getFactory());
            switch (geometry.getGeometryType()) {
                case "Point": {
                    return factory.createPoint(this.convertCoordinate(geometry.getCoordinate()));
                }
                case "LineString": {
                    return factory.createLineString(this.convertCoordinates(geometry.getCoordinates()));
                }
                case "Polygon": {
                    Polygon p = (Polygon)geometry;
                    int n = p.getNumInteriorRing();
                    LinearRing[] holes = new LinearRing[n];
                    for (int i = 0; i < n; ++i) {
                        holes[i] = this.createLinearRing(factory, p.getInteriorRingN(i));
                    }
                    return factory.createPolygon(this.createLinearRing(factory, p.getExteriorRing()), holes);
                }
                case "MultiPoint": 
                case "MultiLineString": 
                case "MultiPolygon": 
                case "GeometryCollection": {
                    int n = geometry.getNumGeometries();
                    ArrayList<com.vividsolutions.jts.geom.Geometry> array = new ArrayList<com.vividsolutions.jts.geom.Geometry>(n);
                    for (int i = 0; i < n; ++i) {
                        array.add(this.convert(geometry.getGeometryN(i)));
                    }
                    return factory.buildGeometry(array);
                }
            }
            throw new IllegalArgumentException("Unsupported cv geometry: " + geometry);
        }

        private com.vividsolutions.jts.geom.GeometryFactory convertFactory(GeometryFactory factory) {
            return new com.vividsolutions.jts.geom.GeometryFactory(this.convertPrecisionModel(factory.getPrecisionModel()), factory.getSRID());
        }

        private PrecisionModel convertPrecisionModel(org.locationtech.jts.geom.PrecisionModel precisionModel) {
            if (precisionModel.getType() == org.locationtech.jts.geom.PrecisionModel.FIXED) {
                return new PrecisionModel(precisionModel.getScale());
            }
            if (precisionModel.getType() == org.locationtech.jts.geom.PrecisionModel.FLOATING) {
                return new PrecisionModel(PrecisionModel.FLOATING);
            }
            if (precisionModel.getType() == org.locationtech.jts.geom.PrecisionModel.FLOATING_SINGLE) {
                return new PrecisionModel(PrecisionModel.FLOATING_SINGLE);
            }
            return new PrecisionModel(new PrecisionModel.Type(precisionModel.getType().toString()));
        }

        private com.vividsolutions.jts.geom.Coordinate convertCoordinate(Coordinate coordinate) {
            return new com.vividsolutions.jts.geom.Coordinate(coordinate.x, coordinate.y, coordinate.z);
        }

        private com.vividsolutions.jts.geom.Coordinate[] convertCoordinates(Coordinate[] coordinates) {
            int n = coordinates.length;
            com.vividsolutions.jts.geom.Coordinate[] array = new com.vividsolutions.jts.geom.Coordinate[n];
            for (int i = 0; i < n; ++i) {
                array[i] = this.convertCoordinate(coordinates[i]);
            }
            return array;
        }

        private LinearRing createLinearRing(com.vividsolutions.jts.geom.GeometryFactory factory, org.locationtech.jts.geom.LineString geometry) {
            return factory.createLinearRing(this.convertCoordinates(geometry.getCoordinates()));
        }
    }
}

