/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Subqueries;
import org.hibernate.spatial.criterion.SpatialFilter;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.I18nPlatformEntity;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.ParameterDao;
import org.n52.series.db.dao.QueryUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PlatformDao
extends ParameterDao<PlatformEntity, I18nPlatformEntity> {
    private static final String SERIES_PROPERTY = "platform";

    public PlatformDao(Session session) {
        super(session);
    }

    @Override
    protected String getDatasetProperty() {
        return SERIES_PROPERTY;
    }

    @Override
    protected Class<PlatformEntity> getEntityClass() {
        return PlatformEntity.class;
    }

    @Override
    protected Class<I18nPlatformEntity> getI18NEntityClass() {
        return I18nPlatformEntity.class;
    }

    @Override
    protected DetachedCriteria addSpatialFilter(DbQuery query, DetachedCriteria criteria) {
        SpatialFilter spatialFilter;
        if (query.getFilterResolver().isSetMobileFilter() && (spatialFilter = query.createSpatialFilter()) != null) {
            String rtAlias = "rtAlias";
            String rtDatasetId = QueryUtils.createAssociation(rtAlias, "seriesPkid");
            String rtResultTime = QueryUtils.createAssociation(rtAlias, "resultTime");
            DetachedCriteria maxResultTimeByDatasetId = DetachedCriteria.forClass(DataEntity.class, (String)rtAlias).setProjection((Projection)Projections.projectionList().add((Projection)Projections.groupProperty((String)rtDatasetId)).add((Projection)Projections.max((String)rtResultTime)));
            String[] matchProperties = new String[]{"seriesPkid", "resultTime"};
            Criterion criterion = Subqueries.propertyIn((String)"pkid", (DetachedCriteria)DetachedCriteria.forClass(DataEntity.class).setProjection((Projection)Projections.property((String)"seriesPkid")).add(Subqueries.propertiesIn((String[])matchProperties, (DetachedCriteria)maxResultTimeByDatasetId)).add((Criterion)spatialFilter));
            criteria.add(criterion);
        }
        return criteria;
    }
}

