/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.n52.io.DatasetFactoryException;
import org.n52.series.db.da.CountDataRepository;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.DefaultDataRepositoryFactory;
import org.n52.series.db.da.IDataRepositoryFactory;
import org.n52.series.db.da.QuantityDataRepository;
import org.n52.series.db.da.TextDataRepository;

public class DataRepositoryFactoryTest {
    private IDataRepositoryFactory factory;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws URISyntaxException {
        File config = this.getConfigFile("dataset-factory.properties");
        this.factory = new DefaultDataRepositoryFactory(config);
    }

    @Test
    public void when_createdWithNoConfig_useDefaultConfig() throws DatasetFactoryException {
        DefaultDataRepositoryFactory m = new DefaultDataRepositoryFactory();
        Assert.assertFalse((boolean)m.isKnown("text"));
        Assert.assertFalse((boolean)m.isKnown("count"));
        Assert.assertTrue((m.create("quantity").getClass() == QuantityDataRepository.class ? 1 : 0) != 0);
    }

    @Test
    public void when_mapToText_then_returnTextDataRepository() throws DatasetFactoryException {
        Assert.assertTrue((this.factory.create("text").getClass() == TextDataRepository.class ? 1 : 0) != 0);
    }

    @Test
    public void when_mapToText_then_returnCountDataRepository() throws DatasetFactoryException {
        Assert.assertTrue((this.factory.create("count").getClass() == CountDataRepository.class ? 1 : 0) != 0);
    }

    @Test
    public void when_mapToText_then_returnQuantityDataRepository() throws DatasetFactoryException {
        Assert.assertTrue((this.factory.create("quantity").getClass() == QuantityDataRepository.class ? 1 : 0) != 0);
    }

    @Test
    public void when_instanceCreated_then_nextTimeFromCache() throws DatasetFactoryException {
        DataRepository instance = this.factory.create("quantity");
        Assert.assertTrue((boolean)this.factory.hasCacheEntry("quantity"));
        Assert.assertTrue((instance == this.factory.create("quantity") ? 1 : 0) != 0);
    }

    private File getConfigFile(String name) throws URISyntaxException {
        Path root = Paths.get(this.getClass().getResource("/files").toURI());
        return root.resolve(name).toFile();
    }
}

