/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.extension.resulttime;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.n52.io.request.IoParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DatasetDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResultTimeRepository
extends SessionAwareRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultTimeRepository.class);

    ResultTimeRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getExtras(String datasetId, IoParameters parameters) {
        Session session = this.getSession();
        try {
            long pkid = Long.parseLong(datasetId);
            DatasetDao dao = new DatasetDao(session);
            DatasetEntity instance = (DatasetEntity)dao.getInstance(pkid, this.getDbQuery(parameters));
            Set<String> set = instance.getResultTimes().stream().map(i -> new DateTime(i).toString()).collect(Collectors.toSet());
            return set;
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Could not convert id '{}' to long.", (Object)datasetId, (Object)e);
        }
        catch (DataAccessException e) {
            LOGGER.error("Could not query result times for dataset with id '{}'", (Object)datasetId, (Object)e);
        }
        finally {
            this.returnSession(session);
        }
        return Collections.emptySet();
    }

    protected String parseToIso(String input) {
        return DateTime.parse((String)input).toString();
    }
}

