/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.TimestampTypeDescriptor;

public final class ZonalTimestampTypeDescriptor
extends TimestampTypeDescriptor {
    private static final long serialVersionUID = -7983231403900402497L;
    private static final TimeZone DEFAULT_ZONE = TimeZone.getTimeZone("UTC");
    private static ZonalTimestampTypeDescriptor instance;
    private static Calendar zonalCalendar;

    private ZonalTimestampTypeDescriptor() {
        this(DEFAULT_ZONE);
    }

    private ZonalTimestampTypeDescriptor(TimeZone zone) {
        if (zone != null) {
            zonalCalendar = Calendar.getInstance(zone);
        }
    }

    public static ZonalTimestampTypeDescriptor getInstance() {
        if (instance == null) {
            instance = new ZonalTimestampTypeDescriptor();
        }
        return instance;
    }

    public static ZonalTimestampTypeDescriptor getInstance(TimeZone zone) {
        if (instance != null) {
            String calendar = zonalCalendar.toString();
            throw new IllegalStateException("Configured already: '" + calendar + "'");
        }
        return new ZonalTimestampTypeDescriptor(zone);
    }

    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, (SqlTypeDescriptor)this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions opts) throws SQLException {
                Timestamp unwrapped = (Timestamp)javaTypeDescriptor.unwrap(value, Timestamp.class, opts);
                st.setTimestamp(index, unwrapped, zonalCalendar);
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, (SqlTypeDescriptor)this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions opts) throws SQLException {
                if (rs.getObject(name) != null) {
                    return javaTypeDescriptor.wrap((Object)rs.getTimestamp(name, zonalCalendar), opts);
                }
                return null;
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions opts) throws SQLException {
                return javaTypeDescriptor.wrap((Object)statement.getTimestamp(index, zonalCalendar), opts);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions opts) throws SQLException {
                return javaTypeDescriptor.wrap((Object)statement.getTimestamp(name, zonalCalendar), opts);
            }
        };
    }

    static {
        zonalCalendar = Calendar.getInstance(DEFAULT_ZONE);
    }
}

