/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import com.vividsolutions.jts.geom.Geometry;
import org.n52.io.crs.CRSUtils;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryEntity {
    public static final String PROPERTY_GEOMETRY = "geometry";
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometryEntity.class);
    private final CRSUtils crsUtils = CRSUtils.createEpsgForcedXYAxisOrder();
    private Geometry geometry;
    private Double lon;
    private Double lat;
    private Double alt;

    public boolean isSetGeometry() {
        return this.geometry != null && !this.geometry.isEmpty();
    }

    public GeometryEntity setGeometry(Geometry geometry) {
        this.geometry = geometry;
        return this;
    }

    public Geometry getGeometry() {
        return this.getGeometry(null);
    }

    public Geometry getGeometry(String srid) {
        Geometry builtGeometry = this.isSetLonLat() ? this.crsUtils.createPoint(this.lon, this.lat, this.alt, srid) : this.geometry;
        try {
            return builtGeometry != null && srid != null ? this.crsUtils.transformOuterToInner(builtGeometry, srid) : builtGeometry;
        }
        catch (FactoryException | TransformException e) {
            LOGGER.warn("Invalid srid '{}'. Could not transform geometry.", e);
            return builtGeometry;
        }
    }

    public boolean isSetLonLat() {
        return this.lon != null && this.lat != null;
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getAlt() {
        return this.alt;
    }

    public void setAlt(Double alt) {
        this.alt = alt;
    }

    public boolean isEmpty() {
        return !this.isSetGeometry() && !this.isSetLonLat();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" [");
        sb.append(" latitude: ").append(this.getLat());
        sb.append(", longitude: ").append(this.getLon());
        return sb.append(" ]").toString();
    }
}

