/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.util.ArrayList;
import java.util.Collection;
import org.n52.series.db.beans.DataEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantityDataEntity
extends DataEntity<Double> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuantityDataEntity.class);
    private static final Double DOUBLE_THRESHOLD = 0.01;

    @Override
    public boolean isNoDataValue(Collection<String> noDataValues) {
        Double value = (Double)this.getValue();
        return value == null || Double.isNaN(value) || this.containsValue(noDataValues, value);
    }

    private boolean containsValue(Collection<String> collection, double key) {
        if (collection == null) {
            return false;
        }
        for (Double noDataValue : this.convertToDoubles(collection)) {
            if (!(Math.abs(noDataValue / key - 1.0) < DOUBLE_THRESHOLD)) continue;
            return true;
        }
        return false;
    }

    private Collection<Double> convertToDoubles(Collection<String> collection) {
        ArrayList<Double> validatedValues = new ArrayList<Double>();
        for (String value : collection) {
            String trimmed = value.trim();
            try {
                validatedValues.add(Double.parseDouble(trimmed));
            }
            catch (NumberFormatException e) {
                LOGGER.trace("Ignoring NO_DATA value {} (not a double).", (Object)trimmed);
            }
        }
        return validatedValues;
    }
}

