/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.count.CountData;
import org.n52.io.response.dataset.count.CountDatasetMetadata;
import org.n52.io.response.dataset.count.CountValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.CountDataEntity;
import org.n52.series.db.beans.CountDatasetEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public class CountDataRepository
extends AbstractDataRepository<CountData, CountDatasetEntity, CountDataEntity, CountValue> {
    @Override
    public Class<CountDatasetEntity> getDatasetEntityType() {
        return CountDatasetEntity.class;
    }

    @Override
    protected CountData assembleDataWithReferenceValues(CountDatasetEntity timeseries, DbQuery dbQuery, Session session) throws DataAccessException {
        CountData result = this.assembleData(timeseries, dbQuery, session);
        Set<CountDatasetEntity> referenceValues = timeseries.getReferenceValues();
        if (referenceValues != null && !referenceValues.isEmpty()) {
            CountDatasetMetadata metadata = new CountDatasetMetadata();
            metadata.setReferenceValues(this.assembleReferenceSeries(referenceValues, dbQuery, session));
            result.setMetadata(metadata);
        }
        return result;
    }

    private Map<String, CountData> assembleReferenceSeries(Set<CountDatasetEntity> referenceValues, DbQuery query, Session session) throws DataAccessException {
        HashMap<String, CountData> referenceSeries = new HashMap<String, CountData>();
        for (CountDatasetEntity referenceSeriesEntity : referenceValues) {
            if (!referenceSeriesEntity.isPublished().booleanValue()) continue;
            CountData referenceSeriesData = this.assembleData(referenceSeriesEntity, query, session);
            if (this.haveToExpandReferenceData(referenceSeriesData)) {
                referenceSeriesData = this.expandReferenceDataIfNecessary(referenceSeriesEntity, query, session);
            }
            referenceSeries.put(referenceSeriesEntity.getPkid().toString(), referenceSeriesData);
        }
        return referenceSeries;
    }

    private boolean haveToExpandReferenceData(CountData referenceSeriesData) {
        return referenceSeriesData.getValues().size() <= 1;
    }

    private CountData expandReferenceDataIfNecessary(CountDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        CountData result = new CountData();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor(seriesEntity, query);
        if (!this.hasValidEntriesWithinRequestedTimespan(observations)) {
            CountValue lastValue = (CountValue)this.getLastValue(seriesEntity, session, query);
            result.addValues((AbstractValue[])this.expandToInterval((Integer)lastValue.getValue(), seriesEntity, query));
        }
        if (this.hasSingleValidReferenceValue(observations)) {
            CountDataEntity entity = (CountDataEntity)observations.get(0);
            result.addValues((AbstractValue[])this.expandToInterval((Integer)entity.getValue(), seriesEntity, query));
        }
        return result;
    }

    @Override
    protected CountData assembleData(CountDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        CountData result = new CountData();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor(seriesEntity, query);
        for (CountDataEntity observation : observations) {
            if (observation == null) continue;
            result.addValues((AbstractValue[])new CountValue[]{this.createSeriesValueFor(observation, seriesEntity, query)});
        }
        return result;
    }

    private CountValue[] expandToInterval(Integer value, CountDatasetEntity series, DbQuery query) {
        CountDataEntity referenceStart = new CountDataEntity();
        CountDataEntity referenceEnd = new CountDataEntity();
        referenceStart.setTimestamp(query.getTimespan().getStart().toDate());
        referenceEnd.setTimestamp(query.getTimespan().getEnd().toDate());
        referenceStart.setValue(value);
        referenceEnd.setValue(value);
        return new CountValue[]{this.createSeriesValueFor(referenceStart, series, query), this.createSeriesValueFor(referenceEnd, series, query)};
    }

    @Override
    public CountValue createSeriesValueFor(CountDataEntity observation, CountDatasetEntity series, DbQuery query) {
        CountValue value;
        if (observation == null) {
            return null;
        }
        ServiceEntity service = this.getServiceEntity(series);
        Integer observationValue = !service.isNoDataValue(observation) ? (Integer)observation.getValue() : null;
        IoParameters parameters = query.getParameters();
        Date timeend = observation.getTimeend();
        Date timestart = observation.getTimestart();
        long end = timeend.getTime();
        long start = timestart.getTime();
        CountValue countValue = value = parameters.isShowTimeIntervals() ? new CountValue(Long.valueOf(start), Long.valueOf(end), observationValue) : new CountValue(Long.valueOf(end), observationValue);
        if (query.isExpanded()) {
            this.addGeometry(observation, (AbstractValue<?>)value);
            this.addValidTime(observation, (AbstractValue<?>)value);
            this.addParameters(observation, (AbstractValue<?>)value, query);
        } else if (series.getPlatform().isMobile()) {
            this.addGeometry(observation, (AbstractValue<?>)value);
        }
        return value;
    }
}

