/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.io.File;
import org.n52.io.ConfigTypedFactory;
import org.n52.series.db.HibernateSessionStore;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.IDataRepositoryFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultDataRepositoryFactory
extends ConfigTypedFactory<DataRepository>
implements IDataRepositoryFactory {
    private static final String DEFAULT_CONFIG_FILE = "dataset-repository-factory.properties";
    @Autowired
    private HibernateSessionStore sessionStore;
    @Autowired
    private ServiceEntity serviceEntity;

    public DefaultDataRepositoryFactory() {
        super(DEFAULT_CONFIG_FILE);
    }

    public DefaultDataRepositoryFactory(File configFile) {
        super(configFile);
    }

    protected DataRepository initInstance(DataRepository instance) {
        instance.setSessionStore(this.sessionStore);
        if (this.serviceEntity != null) {
            instance.setServiceEntity(this.serviceEntity);
        }
        return instance;
    }

    protected String getFallbackConfigResource() {
        return DEFAULT_CONFIG_FILE;
    }

    protected Class<DataRepository> getTargetType() {
        return DataRepository.class;
    }

    public HibernateSessionStore getSessionStore() {
        return this.sessionStore;
    }

    public void setSessionStore(HibernateSessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    public ServiceEntity getServiceEntity() {
        return this.serviceEntity;
    }

    public void setServiceEntity(ServiceEntity serviceEntity) {
        this.serviceEntity = serviceEntity;
    }
}

