/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.FeatureOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.parameter.Parameter;
import org.n52.series.db.da.HierarchicalParameterRepository;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.FeatureDao;
import org.n52.series.spi.search.FeatureSearchResult;
import org.n52.series.spi.search.SearchResult;
import org.n52.web.exception.ResourceNotFoundException;

public class FeatureRepository
extends HierarchicalParameterRepository<FeatureEntity, FeatureOutput> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            FeatureDao dao = this.createDao(session);
            boolean bl = dao.hasInstance(this.parseId(id), parameters, FeatureEntity.class);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    private FeatureDao createDao(Session session) {
        return new FeatureDao(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        Session session = this.getSession();
        try {
            FeatureDao featureDao = this.createDao(session);
            DbQuery query = this.dbQueryFactory.createFrom(parameters);
            List<FeatureEntity> found = featureDao.find(query);
            List<SearchResult> list = this.convertToSearchResults(found, query);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<SearchResult> convertToSearchResults(List<? extends DescribableEntity> found, DbQuery query) {
        String locale = query.getLocale();
        String hrefBase = this.urlHelper.getFeaturesHrefBaseUrl(query.getHrefBase());
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (DescribableEntity describableEntity : found) {
            String pkid = describableEntity.getPkid().toString();
            String label = describableEntity.getLabelFrom(locale);
            results.add((SearchResult)new FeatureSearchResult(pkid, label, hrefBase));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FeatureOutput> getAllCondensed(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<FeatureOutput> list = this.getAllCondensed(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<FeatureOutput> getAllCondensed(DbQuery parameters, Session session) throws DataAccessException {
        return this.createCondensed(this.getAllInstances(parameters, session), parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FeatureOutput> getAllExpanded(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<FeatureOutput> list = this.getAllExpanded(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<FeatureOutput> getAllExpanded(DbQuery parameters, Session session) throws DataAccessException {
        return this.createExpanded(this.getAllInstances(parameters, session), parameters);
    }

    private List<FeatureEntity> getAllInstances(DbQuery parameters, Session session) throws DataAccessException {
        return this.createDao(session).getAllInstances(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureOutput getInstance(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            FeatureOutput featureOutput = this.getInstance(id, parameters, session);
            return featureOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public FeatureOutput getInstance(String id, DbQuery parameters, Session session) throws DataAccessException {
        FeatureDao featureDao = this.createDao(session);
        FeatureEntity result = (FeatureEntity)featureDao.getInstance(this.parseId(id), parameters);
        if (result == null) {
            throw new ResourceNotFoundException("Resource with id '" + id + "' could not be found.");
        }
        return this.createExpanded(result, parameters);
    }

    @Override
    protected FeatureOutput createExpanded(FeatureEntity entity, DbQuery parameters) throws DataAccessException {
        FeatureOutput result = this.createCondensed(entity, parameters);
        if (parameters.getHrefBase() != null) {
            result.setService(this.getCondensedExtendedService(this.getServiceEntity(entity), parameters));
        } else {
            result.setService(this.getCondensedService(this.getServiceEntity(entity), parameters));
        }
        if (entity.hasParameters()) {
            for (Parameter<?> parameter : entity.getParameters()) {
                result.addParameter(parameter.toValueMap(parameters.getLocale()));
            }
        }
        return result;
    }

    @Override
    protected FeatureOutput createCondensed(FeatureEntity entity, DbQuery parameters) {
        FeatureOutput result = new FeatureOutput();
        result.setId(Long.toString(entity.getPkid()));
        result.setLabel(entity.getLabelFrom(parameters.getLocale()));
        result.setDomainId(entity.getDomainId());
        this.checkForHref(result, parameters);
        return result;
    }

    private void checkForHref(FeatureOutput result, DbQuery parameters) {
        if (parameters.getHrefBase() != null) {
            result.setHrefBase(this.urlHelper.getFeaturesHrefBaseUrl(parameters.getHrefBase()));
        }
    }
}

