/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.DatasetFactoryException;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;
import org.n52.io.response.PlatformOutput;
import org.n52.io.response.PlatformType;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.beans.parameter.Parameter;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.DatasetRepository;
import org.n52.series.db.da.IDataRepositoryFactory;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.FeatureDao;
import org.n52.series.db.dao.PlatformDao;
import org.n52.series.spi.search.PlatformSearchResult;
import org.n52.series.spi.search.SearchResult;
import org.n52.web.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PlatformRepository
extends SessionAwareRepository
implements OutputAssembler<PlatformOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformRepository.class);
    private static final String FILTER_STATIONARY = "stationary";
    private static final String FILTER_MOBILE = "mobile";
    private static final String FILTER_INSITU = "insitu";
    private static final String FILTER_REMOTE = "remote";
    @Autowired
    private DatasetRepository<Data> seriesRepository;
    @Autowired
    private IDataRepositoryFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            Long parsedId = this.parseId(PlatformType.extractId((String)id));
            if (PlatformType.isStationaryId((String)id)) {
                FeatureDao featureDao = new FeatureDao(session);
                boolean bl = featureDao.hasInstance(parsedId, parameters, FeatureEntity.class);
                return bl;
            }
            PlatformDao dao = new PlatformDao(session);
            boolean bl = dao.hasInstance(parsedId, parameters, PlatformEntity.class);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PlatformOutput> getAllCondensed(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<PlatformOutput> list = this.getAllCondensed(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<PlatformOutput> getAllCondensed(DbQuery parameters, Session session) throws DataAccessException {
        ArrayList<PlatformOutput> results = new ArrayList<PlatformOutput>();
        for (PlatformEntity entity : this.getAllInstances(parameters, session)) {
            PlatformOutput result = this.createCondensed(entity, parameters);
            results.add(result);
        }
        return results;
    }

    private PlatformOutput createCondensed(PlatformEntity entity, DbQuery parameters) {
        PlatformOutput result = new PlatformOutput(entity.getPlatformType());
        result.setLabel(entity.getLabelFrom(parameters.getLocale()));
        result.setId(Long.toString(entity.getPkid()));
        result.setDomainId(entity.getDomainId());
        result.setHrefBase(this.urlHelper.getPlatformsHrefBaseUrl(parameters.getHrefBase()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PlatformOutput getCondensedInstance(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            PlatformOutput platformOutput = this.getCondensedInstance(id, parameters, session);
            return platformOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    PlatformOutput getCondensedInstance(DatasetEntity<?> series, DbQuery parameters, Session session) throws DataAccessException {
        PlatformEntity entity = this.getEntity(this.getPlatformId(series), parameters, session);
        return this.createCondensed(entity, parameters);
    }

    PlatformOutput getCondensedInstance(String id, DbQuery parameters, Session session) throws DataAccessException {
        PlatformEntity entity = this.getEntity(id, parameters, session);
        return this.createCondensed(entity, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlatformOutput getInstance(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            PlatformOutput platformOutput = this.getInstance(id, parameters, session);
            return platformOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public PlatformOutput getInstance(String id, DbQuery parameters, Session session) throws DataAccessException {
        PlatformEntity entity = this.getEntity(id, parameters, session);
        return this.createExpanded(entity, parameters, session);
    }

    PlatformEntity getEntity(String id, DbQuery parameters, Session session) throws DataAccessException {
        if (PlatformType.isStationaryId((String)id)) {
            return this.getStation(id, parameters, session);
        }
        return this.getPlatform(id, parameters, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PlatformOutput> getAllExpanded(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<PlatformOutput> list = this.getAllExpanded(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<PlatformOutput> getAllExpanded(DbQuery parameters, Session session) throws DataAccessException {
        ArrayList<PlatformOutput> results = new ArrayList<PlatformOutput>();
        for (PlatformEntity entity : this.getAllInstances(parameters, session)) {
            results.add(this.createExpanded(entity, parameters, session));
        }
        return results;
    }

    private PlatformOutput createExpanded(PlatformEntity entity, DbQuery parameters, Session session) throws DataAccessException {
        PlatformOutput result = this.createCondensed(entity, parameters);
        DbQuery query = this.getDbQuery(parameters.getParameters().extendWith("platforms", new String[]{result.getId()}).removeAllOf("platformTypes"));
        List<DatasetOutput> datasets = this.seriesRepository.getAllCondensed(query);
        result.setDatasets(datasets);
        Geometry geometry = entity.getGeometry();
        result.setGeometry(geometry == null ? this.getLastSamplingGeometry(datasets, query, session) : geometry);
        if (entity.hasParameters()) {
            String locale = parameters.getLocale();
            for (Parameter<?> parameter : entity.getParameters()) {
                result.addParameter(parameter.toValueMap(locale));
            }
        }
        return result;
    }

    private Geometry getLastSamplingGeometry(List<DatasetOutput> datasets, DbQuery query, Session session) throws DataAccessException {
        AbstractValue<?> currentLastValue = null;
        for (DatasetOutput dataset : datasets) {
            try {
                String id = dataset.getId();
                DataRepository dataRepository = this.factory.create(dataset.getValueType());
                DatasetEntity<?> entity = this.seriesRepository.getInstanceEntity(id, query, session);
                Object valueToCheck = dataRepository.getLastValue(entity, session, query);
                currentLastValue = this.getLaterValue(currentLastValue, (AbstractValue<?>)valueToCheck);
            }
            catch (DatasetFactoryException e) {
                LOGGER.error("Couldn't create data repository to determing last value of dataset '{}'", (Object)dataset.getId());
            }
        }
        return currentLastValue != null && currentLastValue.isSetGeometry() ? currentLastValue.getGeometry() : null;
    }

    private AbstractValue<?> getLaterValue(AbstractValue<?> currentLastValue, AbstractValue<?> valueToCheck) {
        if (currentLastValue == null) {
            return valueToCheck;
        }
        if (valueToCheck == null) {
            return currentLastValue;
        }
        return currentLastValue.getTimestamp() > valueToCheck.getTimestamp() ? currentLastValue : valueToCheck;
    }

    private PlatformEntity getStation(String id, DbQuery parameters, Session session) throws DataAccessException {
        FeatureDao featureDao = new FeatureDao(session);
        String featureId = PlatformType.extractId((String)id);
        FeatureEntity feature = (FeatureEntity)featureDao.getInstance(Long.parseLong(featureId), parameters);
        if (feature == null) {
            this.throwNewResourceNotFoundException("Station", id);
        }
        return PlatformType.isInsitu((String)id) ? this.convertInsitu(feature) : this.convertRemote(feature);
    }

    private PlatformEntity getPlatform(String id, DbQuery parameters, Session session) throws DataAccessException {
        PlatformDao dao = new PlatformDao(session);
        String platformId = PlatformType.extractId((String)id);
        PlatformEntity result = (PlatformEntity)dao.getInstance(Long.parseLong(platformId), parameters);
        if (result == null) {
            this.throwNewResourceNotFoundException("Platform", id);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        Session session = this.getSession();
        try {
            PlatformDao dao = new PlatformDao(session);
            DbQuery query = this.getDbQuery(parameters);
            List<PlatformEntity> found = dao.find(query);
            List<SearchResult> list = this.convertToSearchResults(found, query);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<SearchResult> convertToSearchResults(List<? extends DescribableEntity> found, DbQuery query) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        String locale = query.getLocale();
        for (DescribableEntity describableEntity : found) {
            String pkid = describableEntity.getPkid().toString();
            String label = describableEntity.getLabelFrom(locale);
            String hrefBase = this.urlHelper.getPlatformsHrefBaseUrl(query.getHrefBase());
            results.add((SearchResult)new PlatformSearchResult(pkid, label, hrefBase));
        }
        return results;
    }

    private List<PlatformEntity> getAllInstances(DbQuery query, Session session) throws DataAccessException {
        ArrayList<PlatformEntity> platforms = new ArrayList<PlatformEntity>();
        FilterResolver filterResolver = query.getFilterResolver();
        if (filterResolver.shallIncludeStationaryPlatformTypes()) {
            platforms.addAll(this.getAllStationary(query, session));
        }
        if (filterResolver.shallIncludeMobilePlatformTypes()) {
            platforms.addAll(this.getAllMobile(query, session));
        }
        return platforms;
    }

    private List<PlatformEntity> getAllStationary(DbQuery query, Session session) throws DataAccessException {
        ArrayList<PlatformEntity> platforms = new ArrayList<PlatformEntity>();
        FilterResolver filterResolver = query.getFilterResolver();
        if (filterResolver.shallIncludeInsituPlatformTypes()) {
            platforms.addAll(this.getAllStationaryInsitu(query, session));
        }
        if (filterResolver.shallIncludeRemotePlatformTypes()) {
            platforms.addAll(this.getAllStationaryRemote(query, session));
        }
        return platforms;
    }

    private List<PlatformEntity> getAllStationaryInsitu(DbQuery parameters, Session session) throws DataAccessException {
        FeatureDao featureDao = new FeatureDao(session);
        DbQuery query = this.createPlatformFilter(parameters, FILTER_STATIONARY, FILTER_INSITU);
        return this.convertAllInsitu(featureDao.getAllInstances(query));
    }

    private List<PlatformEntity> getAllStationaryRemote(DbQuery parameters, Session session) throws DataAccessException {
        FeatureDao featureDao = new FeatureDao(session);
        DbQuery query = this.createPlatformFilter(parameters, FILTER_STATIONARY, FILTER_REMOTE);
        return this.convertAllRemote(featureDao.getAllInstances(query));
    }

    private List<PlatformEntity> getAllMobile(DbQuery query, Session session) throws DataAccessException {
        ArrayList<PlatformEntity> platforms = new ArrayList<PlatformEntity>();
        FilterResolver filterResolver = query.getFilterResolver();
        if (filterResolver.shallIncludeInsituPlatformTypes()) {
            platforms.addAll(this.getAllMobileInsitu(query, session));
        }
        if (filterResolver.shallIncludeRemotePlatformTypes()) {
            platforms.addAll(this.getAllMobileRemote(query, session));
        }
        return platforms;
    }

    private List<PlatformEntity> getAllMobileInsitu(DbQuery parameters, Session session) throws DataAccessException {
        DbQuery query = this.createPlatformFilter(parameters, FILTER_MOBILE, FILTER_INSITU);
        PlatformDao dao = new PlatformDao(session);
        return dao.getAllInstances(query);
    }

    private List<PlatformEntity> getAllMobileRemote(DbQuery parameters, Session session) throws DataAccessException {
        DbQuery query = this.createPlatformFilter(parameters, FILTER_MOBILE, FILTER_REMOTE);
        PlatformDao dao = new PlatformDao(session);
        return dao.getAllInstances(query);
    }

    private DbQuery createPlatformFilter(DbQuery parameters, String ... filterValues) {
        return this.getDbQuery(parameters.getParameters().removeAllOf("platformTypes").extendWith("platformTypes", filterValues));
    }

    private List<PlatformEntity> convertAllInsitu(List<FeatureEntity> entities) {
        ArrayList<PlatformEntity> converted = new ArrayList<PlatformEntity>();
        for (FeatureEntity entity : entities) {
            converted.add(this.convertInsitu(entity));
        }
        return converted;
    }

    private List<PlatformEntity> convertAllRemote(List<FeatureEntity> entities) {
        ArrayList<PlatformEntity> converted = new ArrayList<PlatformEntity>();
        for (FeatureEntity entity : entities) {
            converted.add(this.convertRemote(entity));
        }
        return converted;
    }

    private PlatformEntity convertInsitu(FeatureEntity entity) {
        PlatformEntity platform = this.convertToPlatform(entity);
        platform.setInsitu(true);
        return platform;
    }

    private PlatformEntity convertRemote(FeatureEntity entity) {
        PlatformEntity platform = this.convertToPlatform(entity);
        platform.setInsitu(false);
        return platform;
    }

    private PlatformEntity convertToPlatform(FeatureEntity entity) {
        PlatformEntity result = new PlatformEntity();
        result.setDomainId(entity.getDomainId());
        result.setPkid(entity.getPkid());
        result.setName(entity.getName());
        result.setParameters(entity.getParameters());
        result.setTranslations(entity.getTranslations());
        result.setDescription(entity.getDescription());
        result.setGeometry(entity.getGeometry());
        return result;
    }

    protected PlatformEntity getPlatformEntity(DatasetEntity<?> series, DbQuery query, Session session) throws DataAccessException {
        return this.getEntity(this.getPlatformId(series), query, session);
    }

    private String getPlatformId(DatasetEntity<?> series) {
        PlatformType platformType = series.getProcedure().getPlatformType();
        Long rawId = platformType.isStationary() ? series.getFeature().getPkid() : series.getProcedure().getPkid();
        return platformType.createId(rawId);
    }

    private void throwNewResourceNotFoundException(String resource, String id) throws ResourceNotFoundException {
        throw new ResourceNotFoundException(resource + " with id '" + id + "' could not be found.");
    }
}

