/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.ProcedureOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.da.HierarchicalParameterRepository;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.ProcedureDao;
import org.n52.series.spi.search.ProcedureSearchResult;
import org.n52.series.spi.search.SearchResult;
import org.n52.web.exception.ResourceNotFoundException;

public class ProcedureRepository
extends HierarchicalParameterRepository<ProcedureEntity, ProcedureOutput> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            ProcedureDao dao = this.createDao(session);
            boolean bl = dao.hasInstance(this.parseId(id), parameters, ProcedureEntity.class);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    private ProcedureDao createDao(Session session) {
        return new ProcedureDao(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        Session session = this.getSession();
        try {
            ProcedureDao procedureDao = this.createDao(session);
            DbQuery query = this.getDbQuery(parameters);
            List<ProcedureEntity> found = procedureDao.find(query);
            List<SearchResult> list = this.convertToSearchResults(found, query);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<SearchResult> convertToSearchResults(List<? extends DescribableEntity> found, DbQuery query) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        String locale = query.getLocale();
        String hrefBase = this.urlHelper.getProceduresHrefBaseUrl(query.getHrefBase());
        for (DescribableEntity describableEntity : found) {
            String pkid = Long.toString(describableEntity.getPkid());
            String label = describableEntity.getLabelFrom(locale);
            results.add((SearchResult)new ProcedureSearchResult(pkid, label, hrefBase));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProcedureOutput> getAllCondensed(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<ProcedureOutput> list = this.getAllCondensed(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<ProcedureOutput> getAllCondensed(DbQuery parameters, Session session) throws DataAccessException {
        return this.createCondensed(this.getAllInstances(parameters, session), parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProcedureOutput> getAllExpanded(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<ProcedureOutput> list = this.getAllExpanded(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<ProcedureOutput> getAllExpanded(DbQuery parameters, Session session) throws DataAccessException {
        return this.createExpanded(this.getAllInstances(parameters, session), parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcedureOutput getInstance(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            ProcedureOutput procedureOutput = this.getInstance(id, parameters, session);
            return procedureOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public ProcedureOutput getInstance(String id, DbQuery parameters, Session session) throws DataAccessException {
        ProcedureEntity result = this.getInstance(this.parseId(id), parameters, session);
        return this.createExpanded(result, parameters);
    }

    private ProcedureEntity getInstance(Long id, DbQuery parameters, Session session) throws DataAccessException {
        ProcedureDao procedureDAO = this.createDao(session);
        ProcedureEntity result = procedureDAO.getInstance(id, parameters);
        if (result == null) {
            throw new ResourceNotFoundException("Resource with id '" + id + "' could not be found.");
        }
        return result;
    }

    private List<ProcedureEntity> getAllInstances(DbQuery parameters, Session session) throws DataAccessException {
        return this.createDao(session).getAllInstances(parameters);
    }

    @Override
    protected ProcedureOutput createCondensed(ProcedureEntity entity, DbQuery parameters) {
        ProcedureOutput result = new ProcedureOutput();
        result.setLabel(entity.getLabelFrom(parameters.getLocale()));
        result.setId(Long.toString(entity.getPkid()));
        result.setDomainId(entity.getDomainId());
        this.checkForHref(result, parameters);
        return result;
    }

    @Override
    protected ProcedureOutput createExpanded(ProcedureEntity entity, DbQuery parameters) {
        ProcedureOutput result = this.createCondensed(entity, parameters);
        if (parameters.getHrefBase() != null) {
            result.setService(this.getCondensedExtendedService(this.getServiceEntity(entity), parameters));
        } else {
            result.setService(this.getCondensedService(this.getServiceEntity(entity), parameters));
        }
        result.setParents(this.createCondensed(entity.getParents(), parameters));
        result.setChildren(this.createCondensed(entity.getChildren(), parameters));
        return result;
    }

    protected List<ProcedureOutput> createCondensedHierarchyMembers(Set<ProcedureEntity> members, DbQuery parameters) {
        return members == null ? Collections.emptyList() : members.stream().map(e -> this.createCondensed((ProcedureEntity)e, parameters)).collect(Collectors.toList());
    }

    private void checkForHref(ProcedureOutput result, DbQuery parameters) {
        if (parameters.getHrefBase() != null) {
            result.setHrefBase(this.urlHelper.getProceduresHrefBaseUrl(parameters.getHrefBase()));
        }
    }
}

