/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.quantity.QuantityData;
import org.n52.io.response.dataset.quantity.QuantityDatasetMetadata;
import org.n52.io.response.dataset.quantity.QuantityValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.QuantityDatasetEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public class QuantityDataRepository
extends AbstractDataRepository<QuantityData, QuantityDatasetEntity, QuantityDataEntity, QuantityValue> {
    @Override
    public Class<QuantityDatasetEntity> getDatasetEntityType() {
        return QuantityDatasetEntity.class;
    }

    @Override
    protected QuantityData assembleDataWithReferenceValues(QuantityDatasetEntity timeseries, DbQuery dbQuery, Session session) throws DataAccessException {
        QuantityData result = this.assembleData(timeseries, dbQuery, session);
        Set<QuantityDatasetEntity> referenceValues = timeseries.getReferenceValues();
        if (referenceValues != null && !referenceValues.isEmpty()) {
            QuantityDatasetMetadata metadata = new QuantityDatasetMetadata();
            metadata.setReferenceValues(this.assembleReferenceSeries(referenceValues, dbQuery, session));
            result.setMetadata(metadata);
        }
        return result;
    }

    private Map<String, QuantityData> assembleReferenceSeries(Set<QuantityDatasetEntity> referenceValues, DbQuery query, Session session) throws DataAccessException {
        HashMap<String, QuantityData> referenceSeries = new HashMap<String, QuantityData>();
        for (QuantityDatasetEntity referenceSeriesEntity : referenceValues) {
            if (!referenceSeriesEntity.isPublished().booleanValue()) continue;
            QuantityData referenceSeriesData = this.assembleData(referenceSeriesEntity, query, session);
            if (this.haveToExpandReferenceData(referenceSeriesData)) {
                referenceSeriesData = this.expandReferenceDataIfNecessary(referenceSeriesEntity, query, session);
            }
            referenceSeries.put(referenceSeriesEntity.getPkid().toString(), referenceSeriesData);
        }
        return referenceSeries;
    }

    private boolean haveToExpandReferenceData(QuantityData referenceSeriesData) {
        return referenceSeriesData.getValues().size() <= 1;
    }

    private QuantityData expandReferenceDataIfNecessary(QuantityDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        QuantityData result = new QuantityData();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor(seriesEntity, query);
        if (!this.hasValidEntriesWithinRequestedTimespan(observations)) {
            QuantityValue lastValue = (QuantityValue)this.getLastValue(seriesEntity, session, query);
            result.addValues((AbstractValue[])this.expandToInterval((Double)lastValue.getValue(), seriesEntity, query));
        }
        if (this.hasSingleValidReferenceValue(observations)) {
            QuantityDataEntity entity = (QuantityDataEntity)observations.get(0);
            result.addValues((AbstractValue[])this.expandToInterval((Double)entity.getValue(), seriesEntity, query));
        }
        return result;
    }

    @Override
    protected QuantityData assembleData(QuantityDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        QuantityData result = new QuantityData();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor(seriesEntity, query);
        for (QuantityDataEntity observation : observations) {
            if (observation == null) continue;
            result.addValues((AbstractValue[])new QuantityValue[]{this.createSeriesValueFor(observation, seriesEntity, query)});
        }
        return result;
    }

    private QuantityValue[] expandToInterval(Double value, QuantityDatasetEntity series, DbQuery query) {
        QuantityDataEntity referenceStart = new QuantityDataEntity();
        QuantityDataEntity referenceEnd = new QuantityDataEntity();
        referenceStart.setTimestamp(query.getTimespan().getStart().toDate());
        referenceEnd.setTimestamp(query.getTimespan().getEnd().toDate());
        referenceStart.setValue(value);
        referenceEnd.setValue(value);
        return new QuantityValue[]{this.createSeriesValueFor(referenceStart, series, query), this.createSeriesValueFor(referenceEnd, series, query)};
    }

    @Override
    public QuantityValue createSeriesValueFor(QuantityDataEntity observation, QuantityDatasetEntity series, DbQuery query) {
        if (observation == null) {
            return null;
        }
        QuantityValue value = this.createValue(observation, series, query);
        if (query.isExpanded()) {
            this.addGeometry(observation, (AbstractValue<?>)value);
            this.addValidTime(observation, (AbstractValue<?>)value);
            this.addParameters(observation, (AbstractValue<?>)value, query);
        } else if (series.getPlatform().isMobile()) {
            this.addGeometry(observation, (AbstractValue<?>)value);
        }
        return value;
    }

    private QuantityValue createValue(QuantityDataEntity observation, QuantityDatasetEntity series, DbQuery query) {
        ServiceEntity service = this.getServiceEntity(series);
        Double observationValue = !service.isNoDataValue(observation) ? this.format(observation, series) : null;
        return this.createValue(observationValue, observation, query);
    }

    QuantityValue createValue(Double observationValue, QuantityDataEntity observation, DbQuery query) {
        Date timeend = observation.getTimeend();
        Date timestart = observation.getTimestart();
        long end = timeend.getTime();
        long start = timestart.getTime();
        IoParameters parameters = query.getParameters();
        return parameters.isShowTimeIntervals() ? new QuantityValue(Long.valueOf(start), Long.valueOf(end), observationValue) : new QuantityValue(Long.valueOf(end), observationValue);
    }

    private Double format(QuantityDataEntity observation, QuantityDatasetEntity series) {
        if (observation.getValue() == null) {
            return (Double)observation.getValue();
        }
        int scale = series.getNumberOfDecimals();
        return new BigDecimal((Double)observation.getValue()).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }
}

