/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.profile.ProfileData;
import org.n52.io.response.dataset.profile.ProfileDataItem;
import org.n52.io.response.dataset.profile.ProfileValue;
import org.n52.io.response.dataset.quantity.QuantityValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.ProfileDataEntity;
import org.n52.series.db.beans.ProfileDatasetEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.da.QuantityDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public class QuantityProfileDataRepository
extends AbstractDataRepository<ProfileData, ProfileDatasetEntity, ProfileDataEntity, ProfileValue<Double>> {
    private final QuantityDataRepository quantityRepository = new QuantityDataRepository();

    @Override
    public ProfileValue<Double> getFirstValue(ProfileDatasetEntity dataset, Session session, DbQuery query) {
        query.setComplexParent(true);
        return (ProfileValue)super.getFirstValue(dataset, session, query);
    }

    @Override
    public ProfileValue<Double> getLastValue(ProfileDatasetEntity dataset, Session session, DbQuery query) {
        query.setComplexParent(true);
        return (ProfileValue)super.getLastValue(dataset, session, query);
    }

    @Override
    public Class<ProfileDatasetEntity> getDatasetEntityType() {
        return ProfileDatasetEntity.class;
    }

    private boolean isVertical(Map<String, Object> parameterObject, String verticalName) {
        String parameter = "name";
        if (parameterObject.containsKey(parameter)) {
            String value = (String)parameterObject.get(parameter);
            return value.equalsIgnoreCase(verticalName);
        }
        return false;
    }

    @Override
    protected ProfileValue<Double> createSeriesValueFor(ProfileDataEntity valueEntity, ProfileDatasetEntity datasetEntity, DbQuery query) {
        Date timeend = valueEntity.getTimeend();
        Date timestart = valueEntity.getTimestart();
        long end = timeend.getTime();
        long start = timestart.getTime();
        IoParameters parameters = query.getParameters();
        ProfileValue profile = parameters.isShowTimeIntervals() ? new ProfileValue(Long.valueOf(start), Long.valueOf(end), null) : new ProfileValue(Long.valueOf(end), null);
        ArrayList<ProfileDataItem> dataItems = new ArrayList<ProfileDataItem>();
        for (DataEntity dataEntity : (Set)valueEntity.getValue()) {
            QuantityDataEntity quantityEntity = (QuantityDataEntity)dataEntity;
            QuantityValue valueItem = this.quantityRepository.createValue((Double)quantityEntity.getValue(), quantityEntity, query);
            this.addParameters(quantityEntity, (AbstractValue<?>)valueItem, query);
            for (Map parameterObject : valueItem.getParameters()) {
                String verticalName;
                if (!this.isVertical(parameterObject, verticalName = datasetEntity.getVerticalParameterName())) continue;
                ProfileDataItem dataItem = new ProfileDataItem();
                dataItem.setValue(quantityEntity.getValue());
                dataItem.setVertical((Double)parameterObject.get("value"));
                String verticalUnit = (String)parameterObject.get("unit");
                if (profile.getVerticalUnit() == null) {
                    profile.setVerticalUnit(verticalUnit);
                }
                if (profile.getVerticalUnit() == null || !profile.getVerticalUnit().equals(verticalUnit)) {
                    dataItem.setVerticalUnit(verticalUnit);
                }
                dataItems.add(dataItem);
            }
        }
        profile.setValue(dataItems);
        return profile;
    }

    @Override
    protected ProfileData assembleData(ProfileDatasetEntity datasetEntity, DbQuery query, Session session) throws DataAccessException {
        query.setComplexParent(true);
        ProfileData result = new ProfileData();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor(datasetEntity, query);
        for (ProfileDataEntity observation : observations) {
            if (observation == null) continue;
            result.addValues((AbstractValue[])new ProfileValue[]{this.createSeriesValueFor(observation, datasetEntity, query)});
        }
        return result;
    }

    @Override
    protected ProfileData assembleDataWithReferenceValues(ProfileDatasetEntity datasetEntity, DbQuery dbQuery, Session session) throws DataAccessException {
        return this.assembleData(datasetEntity, dbQuery, session);
    }
}

