/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.I18nCategoryEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CategoryDao
extends AbstractDao<CategoryEntity> {
    private static final String SERIES_PROPERTY = "category";
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryDao.class);

    public CategoryDao(Session session) {
        super(session);
    }

    @Override
    public List<CategoryEntity> find(DbQuery query) {
        LOGGER.debug("find instance: {}", (Object)query);
        Criteria criteria = this.i18n(I18nCategoryEntity.class, this.getDefaultCriteria(), query);
        criteria.add(Restrictions.ilike((String)"name", (Object)("%" + query.getSearchTerm() + "%")));
        return query.addFilters(criteria, this.getDatasetProperty()).list();
    }

    @Override
    public List<CategoryEntity> getAllInstances(DbQuery query) throws DataAccessException {
        LOGGER.debug("get all instances: {}", (Object)query);
        Criteria criteria = this.i18n(I18nCategoryEntity.class, this.getDefaultCriteria(), query);
        return query.addFilters(criteria, this.getDatasetProperty()).list();
    }

    @Override
    protected String getDatasetProperty() {
        return SERIES_PROPERTY;
    }

    @Override
    protected Class<CategoryEntity> getEntityClass() {
        return CategoryEntity.class;
    }
}

