/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.spatial.GeometryType;
import org.hibernate.spatial.criterion.SpatialRestrictions;
import org.hibernate.sql.JoinType;
import org.joda.time.Interval;
import org.n52.io.crs.BoundingBox;
import org.n52.io.crs.CRSUtils;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;
import org.n52.io.response.PlatformType;
import org.n52.io.response.dataset.ValueType;
import org.n52.series.db.DataModelUtil;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.dao.QueryUtils;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbQuery.class);
    private static final String PROPERTY_PKID = "pkid";
    private static final String PROPERTY_LOCALE = "locale";
    private static final String PROPERTY_TRANSLATIONS = "translations";
    private static final String PROPERTY_GEOMETRY_ENTITY = "geometryEntity.geometry";
    private IoParameters parameters = IoParameters.createDefaults();
    private String sridAuthorityCode = "EPSG:4326";

    public DbQuery(IoParameters parameters) {
        if (parameters != null) {
            this.parameters = parameters;
        }
    }

    public void setDatabaseAuthorityCode(String code) {
        this.sridAuthorityCode = code;
    }

    public String getHrefBase() {
        return this.parameters.getHrefBase();
    }

    public String getLocale() {
        return this.parameters.getLocale();
    }

    public String getSearchTerm() {
        return this.parameters.getAsString("q");
    }

    public Interval getTimespan() {
        return this.parameters.getTimespan().toInterval();
    }

    public BoundingBox getSpatialFilter() {
        return this.parameters.getSpatialFilter();
    }

    public boolean isExpanded() {
        return this.parameters.isExpanded();
    }

    public void setComplexParent(boolean complex) {
        this.parameters = this.parameters.extendWith("internal.complex.parent", new String[]{Boolean.toString(complex)});
    }

    public boolean isComplexParent() {
        return this.parameters.getAsBoolean("internal.complex.parent", false);
    }

    public Set<String> getDatasetTypes() {
        return this.parameters.getValueTypes();
    }

    public boolean isSetDatasetTypeFilter() {
        return !this.parameters.getValueTypes().isEmpty();
    }

    public Date getResultTime() {
        return this.parameters.containsParameter("resultTime") ? this.parameters.getResultTime().toDate() : null;
    }

    public String getHandleAsValueTypeFallback() {
        return this.parameters.containsParameter("handleAs") ? this.parameters.getAsString("handleAs") : "quantity";
    }

    public boolean checkTranslationForLocale(Criteria criteria) {
        return !criteria.add((Criterion)Restrictions.like((String)PROPERTY_LOCALE, (Object)this.getCountryCode())).list().isEmpty();
    }

    public Criteria addLocaleTo(Criteria criteria, Class<?> clazz) {
        if (this.getLocale() != null && DataModelUtil.isEntitySupported(clazz, criteria)) {
            Criteria translations = criteria.createCriteria(PROPERTY_TRANSLATIONS, JoinType.LEFT_OUTER_JOIN);
            translations.add((Criterion)Restrictions.or((Criterion)Restrictions.like((String)PROPERTY_LOCALE, (Object)this.getCountryCode()), (Criterion)Restrictions.isNull((String)PROPERTY_LOCALE)));
        }
        return criteria;
    }

    private String getCountryCode() {
        return this.getLocale().split("_")[0];
    }

    public Criteria addTimespanTo(Criteria criteria) {
        if (this.parameters.getTimespan() != null) {
            Interval interval = this.parameters.getTimespan().toInterval();
            Date start = interval.getStart().toDate();
            Date end = interval.getEnd().toDate();
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.between((String)"timestart", (Object)start, (Object)end), (Criterion)Restrictions.between((String)"timeend", (Object)start, (Object)end)));
        }
        return criteria;
    }

    Criteria addPlatformTypeFilter(String parameter, Criteria criteria) {
        FilterResolver filterResolver = this.getFilterResolver();
        if (!filterResolver.shallIncludeAllPlatformTypes()) {
            if (parameter == null || parameter.isEmpty()) {
                criteria.createCriteria("platform").add((Criterion)this.createMobileExpression(filterResolver)).add((Criterion)this.createInsituExpression(filterResolver));
            } else {
                DetachedCriteria c = DetachedCriteria.forClass(DatasetEntity.class, (String)"dataset").createCriteria("procedure").add((Criterion)this.createMobileExpression(filterResolver)).add((Criterion)this.createInsituExpression(filterResolver)).setProjection((Projection)this.matchPropertyPkids("dataset", parameter));
                criteria.add(this.matchPropertyPkids(parameter, c));
            }
        }
        return criteria;
    }

    Criteria addDatasetTypeFilter(String parameter, Criteria criteria) {
        FilterResolver filterResolver;
        Set valueTypes = this.getParameters().getValueTypes();
        if (!(valueTypes.isEmpty() || !(filterResolver = this.getFilterResolver()).shallBehaveBackwardsCompatible() && filterResolver.shallIncludeAllDatasetTypes())) {
            Criterion containsValueType = Restrictions.in((String)"valueType", (Collection)valueTypes);
            if (parameter == null || parameter.isEmpty()) {
                criteria.add(containsValueType);
            } else {
                ProjectionList onPkids = this.matchPropertyPkids("dataset", parameter);
                DetachedCriteria c = DetachedCriteria.forClass(DatasetEntity.class, (String)"dataset").add(containsValueType).setProjection((Projection)onPkids);
                criteria.add(this.matchPropertyPkids(parameter, c));
            }
        }
        return criteria;
    }

    private ProjectionList matchPropertyPkids(String alias, String property) {
        String member = QueryUtils.createAssociation(alias, property);
        String association = QueryUtils.createAssociation(member, PROPERTY_PKID);
        return Projections.projectionList().add((Projection)Projections.property((String)association));
    }

    private Criterion matchPropertyPkids(String property, DetachedCriteria c) {
        return Subqueries.propertyIn((String)QueryUtils.createAssociation(property, PROPERTY_PKID), (DetachedCriteria)c);
    }

    Criteria addLimitAndOffsetFilter(Criteria criteria) {
        if (this.getParameters().containsParameter("offset")) {
            criteria.setFirstResult(this.getParameters().getOffset());
        }
        if (this.getParameters().containsParameter("limit")) {
            criteria.setMaxResults(this.getParameters().getLimit());
        }
        return criteria;
    }

    public Criteria addFilters(Criteria criteria, String seriesProperty) {
        this.addLimitAndOffsetFilter(criteria);
        this.addDetachedFilters(seriesProperty, criteria);
        this.addPlatformTypeFilter(seriesProperty, criteria);
        this.addDatasetTypeFilter(seriesProperty, criteria);
        return this.addSpatialFilterTo(criteria, this);
    }

    private LogicalExpression createMobileExpression(FilterResolver filterResolver) {
        boolean includeStationary = filterResolver.shallIncludeStationaryPlatformTypes();
        boolean includeMobile = filterResolver.shallIncludeMobilePlatformTypes();
        return Restrictions.or((Criterion)Restrictions.eq((String)"mobile", (Object)(!includeStationary ? 1 : 0)), (Criterion)Restrictions.eq((String)"mobile", (Object)includeMobile));
    }

    private LogicalExpression createInsituExpression(FilterResolver filterResolver) {
        boolean includeInsitu = filterResolver.shallIncludeInsituPlatformTypes();
        boolean includeRemote = filterResolver.shallIncludeRemotePlatformTypes();
        return Restrictions.or((Criterion)Restrictions.eq((String)"insitu", (Object)includeInsitu), (Criterion)Restrictions.eq((String)"insitu", (Object)(!includeRemote ? 1 : 0)));
    }

    public Criteria addSpatialFilterTo(Criteria criteria, DbQuery query) {
        BoundingBox spatialFilter = this.parameters.getSpatialFilter();
        if (spatialFilter != null) {
            try {
                CRSUtils crsUtils = CRSUtils.createEpsgForcedXYAxisOrder();
                int databaseSrid = crsUtils.getSrsIdFrom(this.sridAuthorityCode);
                Point ll = (Point)crsUtils.transformInnerToOuter((Geometry)spatialFilter.getLowerLeft(), this.sridAuthorityCode);
                Point ur = (Point)crsUtils.transformInnerToOuter((Geometry)spatialFilter.getUpperRight(), this.sridAuthorityCode);
                Envelope envelope = new Envelope(ll.getCoordinate(), ur.getCoordinate());
                criteria.add((Criterion)SpatialRestrictions.filter((String)PROPERTY_GEOMETRY_ENTITY, (Envelope)envelope, (int)databaseSrid));
            }
            catch (FactoryException e) {
                LOGGER.error("Could not create transformation facilities.", (Throwable)e);
            }
            catch (TransformException e) {
                LOGGER.error("Could not perform transformation.", (Throwable)e);
            }
        }
        Set geometryTypes = this.parameters.getGeometryTypes();
        for (String geometryType : geometryTypes) {
            GeometryType.Type type;
            if (geometryType.isEmpty() || (type = this.getGeometryType(geometryType)) == null) continue;
            criteria.add(SpatialRestrictions.geometryType((String)PROPERTY_GEOMETRY_ENTITY, (GeometryType.Type)type));
        }
        return criteria;
    }

    private GeometryType.Type getGeometryType(String geometryType) {
        for (GeometryType.Type type : GeometryType.Type.values()) {
            if (!type.name().equalsIgnoreCase(geometryType)) continue;
            return type;
        }
        return null;
    }

    public Criteria addDetachedFilters(String propertyName, Criteria criteria) {
        DetachedCriteria filter = DetachedCriteria.forClass(DatasetEntity.class);
        this.addFilterRestriction(this.parameters.getPhenomena(), "phenomenon", filter);
        this.addHierarchicalFilterRestriction(this.parameters.getProcedures(), "procedure", filter, "p_");
        this.addHierarchicalFilterRestriction(this.parameters.getOfferings(), "offering", filter, "off_");
        this.addFilterRestriction(this.parameters.getFeatures(), "feature", filter);
        this.addFilterRestriction(this.parameters.getCategories(), "category", filter);
        this.addFilterRestriction(this.parameters.getSeries(), filter);
        this.addFilterRestriction(this.parameters.getDatasets().stream().map(e -> ValueType.extractId((String)e)).collect(Collectors.toSet()), filter);
        if (this.hasValues(this.parameters.getPlatforms())) {
            Set<String> stationaryIds = this.getStationaryIds(this.parameters.getPlatforms());
            Set<String> mobileIds = this.getMobileIds(this.parameters.getPlatforms());
            if (!stationaryIds.isEmpty()) {
                this.addFilterRestriction(stationaryIds, "feature", filter);
            }
            if (!mobileIds.isEmpty()) {
                this.addFilterRestriction(mobileIds, "procedure", filter);
            }
        }
        String projectionProperty = QueryUtils.createAssociation(propertyName, PROPERTY_PKID);
        filter.setProjection((Projection)Property.forName((String)projectionProperty));
        String filterProperty = QueryUtils.createAssociation(propertyName, PROPERTY_PKID);
        criteria.add(Subqueries.propertyIn((String)filterProperty, (DetachedCriteria)filter));
        return criteria;
    }

    private DetachedCriteria addHierarchicalFilterRestriction(Set<String> values, String entity, DetachedCriteria filter, String prefix) {
        if (this.hasValues(values)) {
            filter.createCriteria(entity, prefix + "e").createAlias(prefix + "e.parents", prefix + "p", JoinType.LEFT_OUTER_JOIN).add((Criterion)Restrictions.or((Criterion)this.createIdCriterion(values, prefix + "e"), (Criterion)Restrictions.in((String)(prefix + "p.pkid"), QueryUtils.parseToIds(values))));
        }
        return filter;
    }

    private DetachedCriteria addFilterRestriction(Set<String> values, DetachedCriteria filter) {
        return this.addFilterRestriction(values, null, filter);
    }

    private DetachedCriteria addFilterRestriction(Set<String> values, String entity, DetachedCriteria filter) {
        if (this.hasValues(values)) {
            Criterion restriction = this.createIdCriterion(values);
            if (entity == null || entity.isEmpty()) {
                return filter.add(restriction);
            }
            return filter.createCriteria(entity).add(restriction);
        }
        return filter;
    }

    private Criterion createIdCriterion(Set<String> values) {
        return this.createIdCriterion(values, null);
    }

    private Criterion createIdCriterion(Set<String> values, String alias) {
        return this.parameters.isMatchDomainIds() ? this.createDomainIdFilter(values, alias) : this.createIdFilter(values, alias);
    }

    private Criterion createDomainIdFilter(Set<String> filterValues, String alias) {
        String column = QueryUtils.createAssociation(alias, "domainId");
        Disjunction disjunction = Restrictions.disjunction();
        for (String filter : filterValues) {
            disjunction.add(Restrictions.ilike((String)column, (Object)filter));
        }
        return disjunction;
    }

    private Criterion createIdFilter(Set<String> filterValues, String alias) {
        String column = QueryUtils.createAssociation(alias, PROPERTY_PKID);
        return Restrictions.in((String)column, QueryUtils.parseToIds(filterValues));
    }

    private boolean hasValues(Set<String> values) {
        return values != null && !values.isEmpty();
    }

    private Set<String> getStationaryIds(Set<String> platforms) {
        HashSet<String> set = new HashSet<String>();
        for (String platform : platforms) {
            if (!PlatformType.isStationaryId((String)platform)) continue;
            set.add(PlatformType.extractId((String)platform));
        }
        return set;
    }

    private Set<String> getMobileIds(Set<String> platforms) {
        HashSet<String> set = new HashSet<String>();
        for (String platform : platforms) {
            if (PlatformType.isStationaryId((String)platform)) continue;
            set.add(PlatformType.extractId((String)platform));
        }
        return set;
    }

    public IoParameters getParameters() {
        return this.parameters;
    }

    public FilterResolver getFilterResolver() {
        return this.parameters.getFilterResolver();
    }

    public String toString() {
        return "DbQuery{ parameters=" + this.getParameters().toString() + "'}'";
    }
}

