/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.extension.parents;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.HierarchicalParameterOutput;
import org.n52.io.response.PlatformOutput;
import org.n52.io.response.ProcedureOutput;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.ValueType;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.da.PlatformRepository;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

class HierarchicalParameterRepository
extends SessionAwareRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(HierarchicalParameterRepository.class);
    private static final String KEY_PROCEDURES = "procedures";
    @Autowired
    private PlatformRepository platformRepository;

    HierarchicalParameterRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Set<HierarchicalParameterOutput>> getExtras(String platformId, IoParameters parameters) {
        Session session = this.getSession();
        try {
            DbQuery dbQuery = this.getDbQuery(parameters);
            HashMap<String, Set<HierarchicalParameterOutput>> extras = new HashMap<String, Set<HierarchicalParameterOutput>>();
            PlatformOutput platform = (PlatformOutput)this.platformRepository.getInstance(platformId, dbQuery);
            DatasetDao dao = new DatasetDao(session);
            for (DatasetOutput dataset : platform.getDatasets()) {
                String datasetId = ValueType.extractId((String)dataset.getId());
                Object instance = dao.getInstance(Long.parseLong(datasetId), dbQuery);
                this.addProcedureParents((DatasetEntity<?>)instance, dbQuery, (Map<String, Set<HierarchicalParameterOutput>>)extras);
            }
            HashMap<String, Set<HierarchicalParameterOutput>> hashMap = extras;
            return hashMap;
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Could not convert id '{}' to long.", (Object)platformId, (Object)e);
        }
        catch (DataAccessException e) {
            LOGGER.error("Could not query hierarchical parameters for dataset with id '{}'", (Object)platformId, (Object)e);
        }
        finally {
            this.returnSession(session);
        }
        return Collections.emptyMap();
    }

    private void addProcedureParents(DatasetEntity<?> instance, DbQuery dbQuery, Map<String, Set<HierarchicalParameterOutput>> extras) {
        if (!extras.containsKey(KEY_PROCEDURES)) {
            extras.put(KEY_PROCEDURES, new HashSet());
        }
        ProcedureEntity entity = instance.getProcedure();
        extras.get(KEY_PROCEDURES).addAll(this.getProcedureParents(entity, dbQuery));
    }

    private Set<? extends HierarchicalParameterOutput> getProcedureParents(ProcedureEntity entity, DbQuery dbQuery) {
        return !entity.hasParents() ? Collections.singleton(this.createCondensed(new ProcedureOutput(), entity, dbQuery)) : new HashSet(entity.getParents().stream().map(e -> this.createCondensed(new ProcedureOutput(), (DescribableEntity)e, dbQuery)).collect(Collectors.toSet()));
    }
}

