/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.extension.resulttime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.n52.io.extension.resulttime.ResultTimeService;
import org.n52.io.request.IoParameters;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.extension.MetadataExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultTimeExtension
extends MetadataExtension<DatasetOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultTimeExtension.class);
    private static final String CONFIG_FILE = "/config-extension-resultTime.json";
    private static final String EXTENSION_NAME = "resultTimes";
    private final List<String> enabledServices = this.readEnabledServices();
    private ResultTimeService service;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> readEnabledServices() {
        try (InputStream taskConfig = ((Object)((Object)this)).getClass().getResourceAsStream(CONFIG_FILE);){
            ObjectMapper om = new ObjectMapper();
            List<Object> list = Arrays.asList((Object[])om.readValue(taskConfig, String[].class));
            return list;
        }
        catch (IOException e) {
            LOGGER.info("Could not load '{}'. Using empty config.", (Object)CONFIG_FILE);
            return Collections.emptyList();
        }
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Collection<String> getExtraMetadataFieldNames(DatasetOutput output) {
        ParameterOutput serviceOutput = output.getDatasetParameters(true).getService();
        return this.isAvailableFor(serviceOutput.getId()) ? Collections.singleton(EXTENSION_NAME) : Collections.emptySet();
    }

    private boolean isAvailableFor(String serviceId) {
        return this.enabledServices.contains(serviceId);
    }

    public Map<String, Object> getExtras(DatasetOutput output, IoParameters parameters) {
        return this.wrapSingleIntoMap(this.getResultTimes(parameters, output));
    }

    private Set<String> getResultTimes(IoParameters parameters, DatasetOutput output) {
        return this.service.getResultTimeList(parameters, output.getId());
    }

    public ResultTimeService getService() {
        return this.service;
    }

    public void setService(ResultTimeService resultTimeService) {
        this.service = resultTimeService;
    }
}

