/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.DatasetFactoryException;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.PlatformOutput;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.DatasetParameters;
import org.n52.io.response.dataset.ValueType;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.IDataRepositoryFactory;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.PlatformRepository;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.spi.search.DatasetSearchResult;
import org.n52.series.spi.search.SearchResult;
import org.n52.web.exception.BadQueryParameterException;
import org.n52.web.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DatasetRepository<T extends Data>
extends SessionAwareRepository
implements OutputAssembler<DatasetOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetRepository.class);
    @Autowired
    private IDataRepositoryFactory dataRepositoryFactory;
    @Autowired
    private PlatformRepository platformRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            String dbId = ValueType.extractId((String)id);
            String handleAsFallback = parameters.getHandleAsValueTypeFallback();
            String valueType = ValueType.extractType((String)id, (String)handleAsFallback);
            if (!this.dataRepositoryFactory.isKnown(valueType)) {
                boolean bl = false;
                return bl;
            }
            DataRepository dataRepository = this.dataRepositoryFactory.create(valueType);
            DatasetDao<DatasetEntity> dao = this.getDatasetDao(valueType, session);
            Class datasetEntityType = dataRepository.getDatasetEntityType();
            boolean bl = parameters.getParameters().isMatchDomainIds() ? dao.hasInstance(dbId, parameters, datasetEntityType) : dao.hasInstance(this.parseId(dbId), parameters, datasetEntityType);
            return bl;
        }
        catch (DatasetFactoryException ex) {
            this.throwNewCreateFactoryException(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DatasetOutput> getAllCondensed(DbQuery query) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<DatasetOutput> list = this.getAllCondensed(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<DatasetOutput> getAllCondensed(DbQuery query, Session session) throws DataAccessException {
        ArrayList<DatasetOutput> results = new ArrayList<DatasetOutput>();
        FilterResolver filterResolver = query.getFilterResolver();
        if (query.getParameters().isMatchDomainIds()) {
            String valueType = query.getHandleAsValueTypeFallback();
            this.addCondensedResults(this.getDatasetDao(valueType, session), query, results, session);
            return results;
        }
        if (filterResolver.shallIncludeAllDatasetTypes()) {
            this.addCondensedResults(this.getDatasetDao(DatasetEntity.class, session), query, results, session);
        } else {
            for (String valueType : query.getValueTypes()) {
                this.addCondensedResults(this.getDatasetDao(valueType, session), query, results, session);
            }
        }
        return results;
    }

    private void addCondensedResults(DatasetDao<? extends DatasetEntity> dao, DbQuery query, List<DatasetOutput> results, Session session) throws DataAccessException {
        for (DatasetEntity datasetEntity : dao.getAllInstances(query)) {
            if (!this.dataRepositoryFactory.isKnown(datasetEntity.getValueType())) continue;
            results.add(this.createCondensed(datasetEntity, query, session));
        }
    }

    private DatasetDao<? extends DatasetEntity> getDatasetDao(Class<? extends DatasetEntity> clazz, Session session) {
        return new DatasetDao<DatasetEntity>(session, clazz);
    }

    private DatasetDao<? extends DatasetEntity> getDatasetDao(String valueType, Session session) throws DataAccessException {
        if (!"all".equalsIgnoreCase(valueType) && !this.dataRepositoryFactory.isKnown(valueType)) {
            throw new BadQueryParameterException("invalid type: " + valueType);
        }
        return this.createDataAccessRepository(valueType, session);
    }

    private DatasetDao<? extends DatasetEntity> getSeriesDao(String datasetId, DbQuery query, Session session) throws DataAccessException {
        String handleAsFallback = query.getHandleAsValueTypeFallback();
        String valueType = ValueType.extractType((String)datasetId, (String)handleAsFallback);
        if (!this.dataRepositoryFactory.isKnown(valueType)) {
            throw new ResourceNotFoundException("unknown type: " + valueType);
        }
        return this.createDataAccessRepository(valueType, session);
    }

    private DatasetDao<? extends DatasetEntity> createDataAccessRepository(String valueType, Session session) throws DataAccessException {
        try {
            DataRepository dataRepository = this.dataRepositoryFactory.create(valueType);
            return this.getDatasetDao(dataRepository.getDatasetEntityType(), session);
        }
        catch (DatasetFactoryException e) {
            throw new DataAccessException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DatasetOutput> getAllExpanded(DbQuery query) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<DatasetOutput> list = this.getAllExpanded(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<DatasetOutput> getAllExpanded(DbQuery query, Session session) throws DataAccessException {
        ArrayList<DatasetOutput> results = new ArrayList<DatasetOutput>();
        FilterResolver filterResolver = query.getFilterResolver();
        if (query.getParameters().isMatchDomainIds()) {
            String valueType = query.getHandleAsValueTypeFallback();
            this.addExpandedResults(this.getDatasetDao(valueType, session), query, results, session);
            return results;
        }
        if (filterResolver.shallIncludeAllDatasetTypes()) {
            this.addExpandedResults(this.getDatasetDao(DatasetEntity.class, session), query, results, session);
        } else {
            for (String valueType : query.getValueTypes()) {
                this.addExpandedResults(this.getDatasetDao(valueType, session), query, results, session);
            }
        }
        return results;
    }

    private void addExpandedResults(DatasetDao<? extends DatasetEntity> dao, DbQuery query, List<DatasetOutput> results, Session session) throws DataAccessException {
        for (DatasetEntity datasetEntity : dao.getAllInstances(query)) {
            if (!this.dataRepositoryFactory.isKnown(datasetEntity.getValueType())) continue;
            results.add(this.createExpanded(datasetEntity, query, session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetOutput getInstance(String id, DbQuery query) throws DataAccessException {
        Session session = this.getSession();
        try {
            DatasetOutput datasetOutput = this.getInstance(id, query, session);
            return datasetOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public DatasetOutput getInstance(String id, DbQuery query, Session session) throws DataAccessException {
        DatasetEntity instanceEntity = this.getInstanceEntity(id, query, session);
        return this.createExpanded(instanceEntity, query, session);
    }

    DatasetEntity getInstanceEntity(String id, DbQuery query, Session session) throws DataAccessException {
        String rawId = ValueType.extractId((String)id);
        DatasetDao<DatasetEntity> dao = this.getSeriesDao(id, query, session);
        Object instance = dao.getInstance(Long.parseLong(rawId), query);
        ((DatasetEntity)instance).setPlatform(this.platformRepository.getPlatformEntity((DatasetEntity)instance, query, session));
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters paramters) {
        Session session = this.getSession();
        try {
            DatasetDao<DatasetEntity> dao = this.getDatasetDao(DatasetEntity.class, session);
            DbQuery query = this.getDbQuery(paramters);
            List<DatasetEntity> found = dao.find(query);
            List<SearchResult> list = this.convertToSearchResults(found, query);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    public List<SearchResult> convertToSearchResults(List<? extends DescribableEntity> found, DbQuery query) {
        String locale = query.getLocale();
        String hrefBase = this.urlHelper.getDatasetsHrefBaseUrl(query.getHrefBase());
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (DescribableEntity describableEntity : found) {
            String pkid = describableEntity.getPkid().toString();
            String label = describableEntity.getLabelFrom(locale);
            results.add((SearchResult)new DatasetSearchResult(pkid, label, hrefBase));
        }
        return results;
    }

    protected DatasetOutput createCondensed(DatasetEntity dataset, DbQuery query, Session session) throws DataAccessException {
        IoParameters parameters = query.getParameters();
        String valueType = dataset.getValueType();
        DatasetOutput result = DatasetOutput.create((String)valueType, (IoParameters)parameters);
        Long id = dataset.getPkid();
        String domainId = dataset.getDomainId();
        String uom = dataset.getUnitI18nName(query.getLocale());
        String label = this.createDatasetLabel(dataset, query.getLocale());
        String hrefBase = this.urlHelper.getDatasetsHrefBaseUrl(query.getHrefBase());
        String platformtype = this.getCondensedPlatform(dataset, query.withoutFieldsFilter(), session).getPlatformType();
        result.setId(id.toString());
        result.setValue("uom", (Object)uom, parameters, arg_0 -> ((DatasetOutput)result).setUom(arg_0));
        result.setValue("label", (Object)label, parameters, arg_0 -> ((DatasetOutput)result).setLabel(arg_0));
        result.setValue("domainid", (Object)domainId, parameters, arg_0 -> ((DatasetOutput)result).setDomainId(arg_0));
        result.setValue("href", (Object)hrefBase, parameters, arg_0 -> ((DatasetOutput)result).setHrefBase(arg_0));
        result.setValue("platformtype", (Object)platformtype, parameters, arg_0 -> ((DatasetOutput)result).setPlatformType(arg_0));
        return result;
    }

    protected DatasetOutput<?> createExpanded(DatasetEntity dataset, DbQuery query, Session session) throws DataAccessException {
        try {
            IoParameters params = query.getParameters();
            DatasetOutput result = this.createCondensed(dataset, query, session);
            DatasetParameters datasetParams = this.createDatasetParameters(dataset, query.withoutFieldsFilter(), session);
            datasetParams.setPlatform((ParameterOutput)this.getCondensedPlatform(dataset, query, session));
            if (dataset.getService() == null) {
                dataset.setService(this.getServiceEntity());
            }
            DataRepository dataRepository = this.dataRepositoryFactory.create(dataset.getValueType());
            Object firstValue = dataRepository.getFirstValue(dataset, session, query);
            Object lastValue = dataset.getFirstValueAt().equals(dataset.getLastValueAt()) ? firstValue : dataRepository.getLastValue(dataset, session, query);
            List refValues = dataRepository.createReferenceValueOutputs(dataset, query);
            lastValue = this.isReferenceSeries(dataset) && this.isCongruentValues((AbstractValue<?>)firstValue, (AbstractValue<?>)lastValue) ? firstValue : lastValue;
            result.setValue("referencevalues", refValues, params, arg_0 -> ((DatasetOutput)result).setReferenceValues(arg_0));
            result.setValue("parameters", (Object)datasetParams, params, arg_0 -> ((DatasetOutput)result).setDatasetParameters(arg_0));
            result.setValue("firstvalue", firstValue, params, arg_0 -> ((DatasetOutput)result).setFirstValue(arg_0));
            result.setValue("lastvalue", lastValue, params, arg_0 -> ((DatasetOutput)result).setLastValue(arg_0));
            return result;
        }
        catch (DatasetFactoryException ex) {
            this.throwNewCreateFactoryException(ex);
            return null;
        }
    }

    private boolean isCongruentValues(AbstractValue<?> firstValue, AbstractValue<?> lastValue) {
        return firstValue.getTimestamp().equals(lastValue.getTimestamp());
    }

    private boolean isReferenceSeries(DatasetEntity<?> series) {
        return series.getProcedure().isReference();
    }

    private PlatformOutput getCondensedPlatform(DatasetEntity dataset, DbQuery query, Session session) throws DataAccessException {
        return this.platformRepository.createCondensedPlatform(dataset, query, session);
    }

    private String createDatasetLabel(DatasetEntity dataset, String locale) {
        PhenomenonEntity phenomenon = dataset.getPhenomenon();
        ProcedureEntity procedure = dataset.getProcedure();
        OfferingEntity offering = dataset.getOffering();
        FeatureEntity feature = dataset.getFeature();
        String procedureLabel = procedure.getLabelFrom(locale);
        String phenomenonLabel = phenomenon.getLabelFrom(locale);
        String offeringLabel = offering.getLabelFrom(locale);
        String stationLabel = feature.getLabelFrom(locale);
        StringBuilder sb = new StringBuilder();
        return sb.append(phenomenonLabel).append(" ").append(procedureLabel).append(", ").append(stationLabel).append(", ").append(offeringLabel).toString();
    }

    public IDataRepositoryFactory getDataRepositoryFactory() {
        return this.dataRepositoryFactory;
    }

    public void setDataRepositoryFactory(IDataRepositoryFactory dataRepositoryFactory) {
        this.dataRepositoryFactory = dataRepositoryFactory;
    }

    private void throwNewCreateFactoryException(DatasetFactoryException e) throws DataAccessException {
        throw new DataAccessException("Could not create dataset factory.", e);
    }
}

