/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.profile.ProfileDataItem;
import org.n52.io.response.dataset.profile.ProfileValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.ProfileDataEntity;
import org.n52.series.db.beans.ProfileDatasetEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public abstract class ProfileDataRepository<T, P extends ProfileDatasetEntity>
extends AbstractDataRepository<P, ProfileDataEntity, ProfileValue<T>> {
    private static final String PARAMETER_NAME = "name";
    private static final String PARAMETER_VALUE = "value";
    private static final String PARAMETER_UNIT = "unit";

    @Override
    public ProfileValue<T> getFirstValue(P dataset, Session session, DbQuery query) {
        query.setComplexParent(true);
        return (ProfileValue)super.getFirstValue(dataset, session, query);
    }

    @Override
    public ProfileValue<T> getLastValue(P dataset, Session session, DbQuery query) {
        query.setComplexParent(true);
        return (ProfileValue)super.getLastValue(dataset, session, query);
    }

    protected boolean isVertical(Map<String, Object> parameterObject, String verticalName) {
        if (parameterObject.containsKey(PARAMETER_NAME)) {
            String value = (String)parameterObject.get(PARAMETER_NAME);
            return value.equalsIgnoreCase(verticalName);
        }
        return false;
    }

    @Override
    protected Data<ProfileValue<T>> assembleData(P datasetEntity, DbQuery query, Session session) throws DataAccessException {
        query.setComplexParent(true);
        Data result = new Data();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor((DatasetEntity)datasetEntity, query);
        for (ProfileDataEntity observation : observations) {
            if (observation == null) continue;
            result.addValues((AbstractValue[])new ProfileValue[]{this.createSeriesValueFor(observation, datasetEntity, query)});
        }
        return result;
    }

    @Override
    protected Data<ProfileValue<T>> assembleDataWithReferenceValues(P datasetEntity, DbQuery dbQuery, Session session) throws DataAccessException {
        return this.assembleData(datasetEntity, dbQuery, session);
    }

    protected ProfileValue<T> createProfileValue(ProfileDataEntity observation, DbQuery query) {
        Date timeend = observation.getTimeend();
        Date timestart = observation.getTimestart();
        long end = timeend.getTime();
        long start = timestart.getTime();
        IoParameters parameters = query.getParameters();
        ProfileValue profile = parameters.isShowTimeIntervals() ? new ProfileValue(Long.valueOf(start), Long.valueOf(end), null) : new ProfileValue(Long.valueOf(end), null);
        return profile;
    }

    @Override
    protected ProfileValue<T> createSeriesValueFor(ProfileDataEntity observation, P dataset, DbQuery query) {
        ProfileValue<T> profile = this.createValue(observation, (ProfileDatasetEntity)dataset, query);
        return this.addMetadatasIfNeeded(observation, profile, dataset, query);
    }

    protected abstract ProfileValue<T> createValue(ProfileDataEntity var1, ProfileDatasetEntity var2, DbQuery var3);

    protected <E extends DataEntity<T>> ProfileDataItem<T> assembleDataItem(E dataEntity, ProfileValue<T> profile, Map<String, Object> parameterObject) {
        ProfileDataItem dataItem = new ProfileDataItem();
        dataItem.setValue(dataEntity.getValue());
        dataItem.setVertical((BigDecimal)parameterObject.get(PARAMETER_VALUE));
        String verticalUnit = (String)parameterObject.get(PARAMETER_VALUE);
        if (profile.getVerticalUnit() == null) {
            profile.setVerticalUnit(verticalUnit);
        }
        if (profile.getVerticalUnit() == null || !profile.getVerticalUnit().equals(verticalUnit)) {
            dataItem.setVerticalUnit(verticalUnit);
        }
        return dataItem;
    }

    protected <E extends DataEntity<T>> ProfileDataItem<T> assembleDataItem(E dataEntity, ProfileValue<T> profile, Set<Map<String, Object>> parameters, ProfileDatasetEntity dataset) {
        ProfileDataItem dataItem = new ProfileDataItem();
        dataItem.setValue(dataEntity.getValue());
        String verticalUnit = this.getVerticalUnit(parameters, dataset);
        this.addValues(dataItem, parameters, dataset);
        if (profile.getVerticalUnit() == null || !profile.getVerticalUnit().equals(verticalUnit)) {
            dataItem.setVerticalUnit(verticalUnit);
        }
        return dataItem;
    }

    private void addValues(ProfileDataItem<T> dataItem, Set<Map<String, Object>> parameters, ProfileDatasetEntity dataset) {
        if (this.getParameterNames(parameters).contains(dataset.getVerticalParameterName())) {
            dataItem.setVertical(this.getVerticalValue(parameters, dataset.getVerticalParameterName()));
        } else if (this.getParameterNames(parameters).contains(dataset.getVerticalFromParameterName()) && this.getParameterNames(parameters).contains(dataset.getVerticalToParameterName())) {
            dataItem.setVerticalFrom(this.getVerticalValue(parameters, dataset.getVerticalFromParameterName()));
            dataItem.setVertical(this.getVerticalValue(parameters, dataset.getVerticalToParameterName()));
        }
    }

    private BigDecimal getVerticalValue(Set<Map<String, Object>> parameters, String verticalName) {
        for (Map<String, Object> parameterObject : parameters) {
            if (!this.isVertical(parameterObject, verticalName)) continue;
            return (BigDecimal)parameterObject.get(PARAMETER_VALUE);
        }
        return null;
    }

    private String getVerticalUnit(Set<Map<String, Object>> parameters, ProfileDatasetEntity dataset) {
        String unit = null;
        for (Map<String, Object> parameter : parameters) {
            if (unit != null || !parameter.containsKey(PARAMETER_NAME) || !parameter.get(PARAMETER_NAME).equals(dataset.getVerticalParameterName()) && !parameter.get(PARAMETER_NAME).equals(dataset.getVerticalFromParameterName()) && !parameter.get(PARAMETER_NAME).equals(dataset.getVerticalToParameterName())) continue;
            unit = (String)parameter.get(PARAMETER_UNIT);
        }
        return unit;
    }

    private Set<String> getParameterNames(Set<Map<String, Object>> parameters) {
        HashSet<String> names = new HashSet<String>();
        for (Map<String, Object> parameter : parameters) {
            if (!parameter.containsKey(PARAMETER_NAME)) continue;
            names.add((String)parameter.get(PARAMETER_NAME));
        }
        return names;
    }
}

