/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.criterion.Subqueries;
import org.joda.time.DateTime;
import org.n52.io.request.IoParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.CategoryDataEntity;
import org.n52.series.db.beans.CategoryDatasetEntity;
import org.n52.series.db.beans.CountDataEntity;
import org.n52.series.db.beans.CountDatasetEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.ProfileDataEntity;
import org.n52.series.db.beans.ProfileDatasetEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.QuantityDatasetEntity;
import org.n52.series.db.beans.RecordDataEntity;
import org.n52.series.db.beans.RecordDatasetEntity;
import org.n52.series.db.beans.TextDataEntity;
import org.n52.series.db.beans.TextDatasetEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.QueryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DataDao<T extends DataEntity>
extends AbstractDao<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataDao.class);
    private final Class<T> entityType;

    public DataDao(Session session) {
        this(session, DataEntity.class);
    }

    public DataDao(Session session, Class<T> clazz) {
        super(session);
        this.entityType = clazz;
    }

    @Override
    public T getInstance(Long key, DbQuery parameters) throws DataAccessException {
        LOGGER.debug("get instance '{}': {}", (Object)key, (Object)parameters);
        return (T)((DataEntity)this.entityType.cast(this.session.get(this.entityType, (Serializable)key)));
    }

    @Override
    public List<T> getAllInstances(DbQuery parameters) throws DataAccessException {
        LOGGER.debug("get all instances: {}", (Object)parameters);
        Criteria criteria = this.getDefaultCriteria(parameters);
        parameters.addTimespanTo(criteria);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(DataDao.toSQLString(criteria));
        }
        return criteria.list();
    }

    public List<T> getAllInstancesFor(DatasetEntity series, DbQuery query) throws DataAccessException {
        Long pkid = series.getPkid();
        LOGGER.debug("get all instances for series '{}': {}", (Object)pkid, (Object)query);
        SimpleExpression equalsPkid = Restrictions.eq((String)"seriesPkid", (Object)pkid);
        Criteria criteria = this.getDefaultCriteria(query, series).add((Criterion)equalsPkid);
        query.addTimespanTo(criteria);
        if (!(!query.isExpanded() || query.getParameters().containsParameter("format") && ("highcharts".equalsIgnoreCase(query.getParameters().getFormat()) || "flotcharts".equalsIgnoreCase(query.getParameters().getFormat()) || "flot".equalsIgnoreCase(query.getParameters().getFormat())))) {
            criteria.setFetchMode("parameters", FetchMode.JOIN);
        }
        return criteria.list();
    }

    @Override
    protected Class<T> getEntityClass() {
        return this.entityType;
    }

    @Override
    protected String getDatasetProperty() {
        return "";
    }

    private Criteria getDefaultCriteria(DbQuery query, DatasetEntity series) {
        Class<Object> specific = this.entityType;
        if (series instanceof QuantityDatasetEntity) {
            specific = QuantityDataEntity.class;
        } else if (series instanceof CategoryDatasetEntity) {
            specific = CategoryDataEntity.class;
        } else if (series instanceof CountDatasetEntity) {
            specific = CountDataEntity.class;
        } else if (series instanceof TextDatasetEntity) {
            specific = TextDataEntity.class;
        } else if (series instanceof ProfileDatasetEntity) {
            specific = ProfileDataEntity.class;
        } else if (series instanceof RecordDatasetEntity) {
            specific = RecordDataEntity.class;
        }
        return this.addRestrictions(this.session.createCriteria(specific), query);
    }

    @Override
    public Criteria getDefaultCriteria(DbQuery query) {
        return this.addRestrictions(this.session.createCriteria(this.entityType), query);
    }

    private Criteria addRestrictions(Criteria criteria, DbQuery query) {
        criteria.addOrder(Order.asc((String)"timeend")).add((Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        query.addSpatialFilter(criteria);
        query.addResultTimeFilter(criteria);
        query.addOdataFilterForData(criteria);
        return query.isComplexParent() ? criteria.add((Criterion)Restrictions.eq((String)"parent", (Object)true)) : criteria.add((Criterion)Restrictions.eq((String)"parent", (Object)false));
    }

    public T getDataValueViaTimeend(DatasetEntity series, DbQuery query) {
        Date timeend = series.getLastValueAt();
        Criteria criteria = this.createDataAtCriteria(timeend, "timeend", series, query);
        return (T)((DataEntity)criteria.uniqueResult());
    }

    public T getDataValueViaTimestart(DatasetEntity series, DbQuery query) {
        Date timestart = series.getFirstValueAt();
        Criteria criteria = this.createDataAtCriteria(timestart, "timestart", series, query);
        return (T)((DataEntity)criteria.uniqueResult());
    }

    public GeometryEntity getValueGeometryViaTimeend(DatasetEntity series, DbQuery query) {
        Date lastValueAt = series.getLastValueAt();
        Criteria criteria = this.createDataAtCriteria(lastValueAt, "timeend", series, query);
        criteria.setProjection((Projection)Projections.property((String)"geometryEntity"));
        return (GeometryEntity)criteria.uniqueResult();
    }

    private Criteria createDataAtCriteria(Date timestamp, String column, DatasetEntity dataset, DbQuery query) {
        LOGGER.debug("get data @{} for '{}'", (Object)new DateTime(timestamp.getTime()), (Object)dataset.getPkid());
        Criteria criteria = this.getDefaultCriteria(query).add((Criterion)Restrictions.eq((String)column, (Object)timestamp)).add((Criterion)Restrictions.eq((String)"seriesPkid", (Object)dataset.getPkid()));
        IoParameters parameters = query.getParameters();
        if (parameters.isAllResultTimes()) {
            return criteria;
        }
        if (!parameters.getResultTimes().isEmpty()) {
            return query.addResultTimeFilter(criteria);
        }
        String rtAlias = "rtAlias";
        String rtColumn = QueryUtils.createAssociation(rtAlias, column);
        String rtDatasetId = QueryUtils.createAssociation(rtAlias, "seriesPkid");
        String rtResultTime = QueryUtils.createAssociation(rtAlias, "resultTime");
        DetachedCriteria maxResultTimeQuery = DetachedCriteria.forClass(this.getEntityClass(), (String)rtAlias);
        maxResultTimeQuery.add((Criterion)Restrictions.eq((String)"seriesPkid", (Object)dataset.getPkid())).setProjection((Projection)Projections.projectionList().add((Projection)Projections.groupProperty((String)rtColumn)).add((Projection)Projections.groupProperty((String)rtDatasetId)).add((Projection)Projections.max((String)rtResultTime)));
        criteria.add(Subqueries.propertiesIn((String[])new String[]{column, "seriesPkid", "resultTime"}, (DetachedCriteria)maxResultTimeQuery));
        return criteria;
    }
}

