/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.srv;

import org.n52.io.DatasetFactoryException;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DataCollection;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.ValueType;
import org.n52.io.series.TvpDataCollection;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.DatasetRepository;
import org.n52.series.db.da.IDataRepositoryFactory;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.spi.srv.DataService;
import org.n52.series.srv.AccessService;
import org.n52.web.exception.InternalServerException;
import org.n52.web.exception.ResourceNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;

public class DatasetAccessService
extends AccessService<DatasetOutput>
implements DataService<Data<AbstractValue<?>>> {
    @Autowired
    private IDataRepositoryFactory dataFactory;

    public DatasetAccessService(DatasetRepository<Data<?>> repository) {
        super(repository);
    }

    public DataCollection<Data<AbstractValue<?>>> getData(IoParameters parameters) {
        try {
            TvpDataCollection dataCollection = new TvpDataCollection();
            for (String seriesId : parameters.getDatasets()) {
                Data<AbstractValue<?>> data = this.getDataFor(seriesId, parameters);
                if (data == null) continue;
                dataCollection.addNewSeries(seriesId, data);
            }
            return dataCollection;
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Could not get series data from database.", (Throwable)e);
        }
    }

    private Data<AbstractValue<?>> getDataFor(String datasetId, IoParameters parameters) throws DataAccessException {
        DbQuery dbQuery = this.dbQueryFactory.createFrom(parameters);
        String handleAsDatasetFallback = parameters.getAsString("handleAs");
        String valueType = ValueType.extractType((String)datasetId, (String)handleAsDatasetFallback);
        DataRepository dataRepository = this.createRepository(valueType);
        return dataRepository.getData(datasetId, dbQuery);
    }

    private DataRepository createRepository(String valueType) throws DataAccessException {
        if (!"all".equalsIgnoreCase(valueType) && !this.dataFactory.isKnown(valueType)) {
            throw new ResourceNotFoundException("unknown type: " + valueType);
        }
        try {
            return this.dataFactory.create(valueType);
        }
        catch (DatasetFactoryException e) {
            throw new DataAccessException(e.getMessage());
        }
    }
}

