/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.ReferenceValueOutput;
import org.n52.io.response.dataset.ValueType;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.parameter.Parameter;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;

public abstract class AbstractDataRepository<S extends DatasetEntity<?>, E extends DataEntity<?>, V extends AbstractValue<?>>
extends SessionAwareRepository
implements DataRepository<S, V> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Data<? extends AbstractValue<?>> getData(String datasetId, DbQuery dbQuery) throws DataAccessException {
        Session session = this.getSession();
        try {
            String id = ValueType.extractId((String)datasetId);
            DatasetDao<S> seriesDao = this.getSeriesDao(session);
            IoParameters parameters = dbQuery.getParameters();
            DatasetEntity series = (DatasetEntity)seriesDao.getInstance(id, this.getDbQuery(parameters.removeAllOf("bbox").removeAllOf("near").removeAllOf("$filter")));
            if (series.getService() == null) {
                series.setService(this.getServiceEntity());
            }
            Data<V> data = dbQuery.isExpanded() ? this.assembleDataWithReferenceValues(series, dbQuery, session) : this.assembleData(series, dbQuery, session);
            return data;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public V getFirstValue(S entity, Session session, DbQuery query) {
        DataDao<E> dao = this.createDataDao(session);
        E valueEntity = dao.getDataValueViaTimestart((DatasetEntity)entity, query);
        return valueEntity != null ? (V)this.createSeriesValueFor(valueEntity, entity, query) : null;
    }

    @Override
    public V getLastValue(S entity, Session session, DbQuery query) {
        DataDao<E> dao = this.createDataDao(session);
        E valueEntity = dao.getDataValueViaTimeend((DatasetEntity)entity, query);
        return valueEntity != null ? (V)this.createSeriesValueFor(valueEntity, entity, query) : null;
    }

    @Override
    public GeometryEntity getLastKnownGeometry(S entity, Session session, DbQuery query) {
        DataDao<E> dao = this.createDataDao(session);
        return dao.getValueGeometryViaTimeend((DatasetEntity)entity, query);
    }

    protected DatasetDao<S> getSeriesDao(Session session) {
        return new DatasetDao(session);
    }

    protected DataDao<E> createDataDao(Session session) {
        return new DataDao(session);
    }

    @Override
    public List<ReferenceValueOutput<V>> createReferenceValueOutputs(S datasetEntity, DbQuery query) {
        return new ArrayList<ReferenceValueOutput<V>>();
    }

    protected abstract V createSeriesValueFor(E var1, S var2, DbQuery var3);

    protected abstract Data<V> assembleData(S var1, DbQuery var2, Session var3) throws DataAccessException;

    protected Data<V> assembleDataWithReferenceValues(S datasetEntity, DbQuery dbQuery, Session session) throws DataAccessException {
        return this.assembleData(datasetEntity, dbQuery, session);
    }

    protected boolean hasValidEntriesWithinRequestedTimespan(List<?> observations) {
        return observations.size() > 0;
    }

    protected boolean hasSingleValidReferenceValue(List<?> observations) {
        return observations.size() == 1;
    }

    protected V addMetadatasIfNeeded(E observation, V value, S dataset, DbQuery query) {
        this.addResultTime((DataEntity<?>)observation, (AbstractValue<?>)value);
        if (query.isExpanded()) {
            this.addValidTime((DataEntity<?>)observation, (AbstractValue<?>)value);
            this.addParameters((DataEntity<?>)observation, (AbstractValue<?>)value, query);
            this.addGeometry((DataEntity<?>)observation, (AbstractValue<?>)value, query);
        } else if (((DatasetEntity)dataset).getPlatform().isMobile()) {
            this.addGeometry((DataEntity<?>)observation, (AbstractValue<?>)value, query);
        }
        return value;
    }

    protected void addGeometry(DataEntity<?> dataEntity, AbstractValue<?> value, DbQuery query) {
        if (dataEntity.isSetGeometry()) {
            GeometryEntity geometry = dataEntity.getGeometryEntity();
            value.setGeometry(geometry.getGeometry());
        }
    }

    protected void addValidTime(DataEntity<?> observation, AbstractValue<?> value) {
        if (observation.isSetValidStartTime() || observation.isSetValidEndTime()) {
            Long validFrom = observation.isSetValidStartTime() ? Long.valueOf(observation.getValidTimeStart().getTime()) : null;
            Long validUntil = observation.isSetValidEndTime() ? Long.valueOf(observation.getValidTimeEnd().getTime()) : null;
            value.setValidTime(new AbstractValue.ValidTime(validFrom, validUntil));
        }
    }

    protected void addResultTime(DataEntity<?> observation, AbstractValue<?> value) {
        if (observation.getResultTime() != null) {
            value.setResultTime(Long.valueOf(observation.getResultTime().getTime()));
        }
    }

    protected void addParameters(DataEntity<?> observation, AbstractValue<?> value, DbQuery query) {
        if (observation.hasParameters()) {
            for (Parameter<?> parameter : observation.getParameters()) {
                value.addParameter(parameter.toValueMap(query.getLocale()));
            }
        }
    }
}

