/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.HibernateSessionStore;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.CategoryDao;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.DbQueryFactory;
import org.n52.series.db.dao.FeatureDao;
import org.n52.series.db.dao.OfferingDao;
import org.n52.series.db.dao.PhenomenonDao;
import org.n52.series.db.dao.PlatformDao;
import org.n52.series.db.dao.ProcedureDao;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityCounter {
    @Autowired
    private HibernateSessionStore sessionStore;
    @Autowired
    private DbQueryFactory dbQueryFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countFeatures(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Integer n = this.getCount(new FeatureDao(session), query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countOfferings(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Integer n = this.getCount(new OfferingDao(session), query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countProcedures(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Integer n = this.getCount(new ProcedureDao(session), query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countPhenomena(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Integer n = this.getCount(new PhenomenonDao(session), query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countCategories(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Integer n = this.getCount(new CategoryDao(session), query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countPlatforms(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Integer n = this.getCount(new PlatformDao(session), query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countDatasets(DbQuery query) throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            Integer n = this.getCount(new DatasetDao<DatasetEntity>(session, DatasetEntity.class), query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countStations() throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            DbQuery query = this.createBackwardsCompatibleQuery();
            Integer n = this.countFeatures(query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer countTimeseries() throws DataAccessException {
        Session session = this.sessionStore.getSession();
        try {
            DbQuery query = this.createBackwardsCompatibleQuery();
            Integer n = this.countDatasets(query);
            return n;
        }
        finally {
            this.sessionStore.returnSession(session);
        }
    }

    public Integer getCount(AbstractDao<?> dao, DbQuery query) throws DataAccessException {
        return dao.getCount(query);
    }

    private DbQuery createBackwardsCompatibleQuery() {
        IoParameters parameters = IoParameters.createDefaults();
        parameters = parameters.extendWith("platformTypes", new String[]{"stationary", "insitu"}).extendWith("valueTypes", new String[]{"quantity"});
        return this.dbQueryFactory.createFrom(parameters);
    }
}

