/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.n52.io.response.ProcedureOutput;
import org.n52.io.response.ServiceOutput;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.da.HierarchicalParameterRepository;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.ProcedureDao;
import org.n52.series.db.dao.SearchableDao;
import org.n52.series.spi.search.FeatureSearchResult;
import org.n52.series.spi.search.SearchResult;

public class ProcedureRepository
extends HierarchicalParameterRepository<ProcedureEntity, ProcedureOutput> {
    @Override
    protected ProcedureOutput prepareEmptyParameterOutput(ProcedureEntity entity) {
        return new ProcedureOutput();
    }

    @Override
    protected SearchResult createEmptySearchResult(String id, String label, String baseUrl) {
        return new FeatureSearchResult(id, label, baseUrl);
    }

    @Override
    protected String createHref(String hrefBase) {
        return this.urlHelper.getProceduresHrefBaseUrl(hrefBase);
    }

    protected ProcedureDao createDao(Session session) {
        return new ProcedureDao(session);
    }

    @Override
    protected SearchableDao<ProcedureEntity> createSearchableDao(Session session) {
        return new ProcedureDao(session);
    }

    @Override
    protected ProcedureOutput createExpanded(ProcedureEntity entity, DbQuery query, Session session) {
        ProcedureOutput result = (ProcedureOutput)this.createCondensed(entity, query, session);
        ServiceOutput service = query.getHrefBase() != null ? this.getCondensedExtendedService(this.getServiceEntity(entity), query) : this.getCondensedService(this.getServiceEntity(entity), query);
        result.setValue("service", (Object)service, query.getParameters(), arg_0 -> ((ProcedureOutput)result).setService(arg_0));
        result.setParents(this.createCondensed(entity.getParents(), query, session));
        result.setChildren(this.createCondensed(entity.getChildren(), query, session));
        return result;
    }

    protected List<ProcedureOutput> createCondensedHierarchyMembers(Set<ProcedureEntity> members, DbQuery parameters, Session session) {
        return members == null ? Collections.emptyList() : members.stream().map(e -> (ProcedureOutput)this.createCondensed(e, parameters, session)).collect(Collectors.toList());
    }
}

