/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.DatasetParameters;
import org.n52.io.response.dataset.StationOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.QuantityDatasetEntity;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.SearchableRepository;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.FeatureDao;
import org.n52.series.spi.search.SearchResult;
import org.n52.series.spi.search.StationSearchResult;
import org.n52.web.exception.BadRequestException;
import org.n52.web.exception.ResourceNotFoundException;

@Deprecated
public class StationRepository
extends SessionAwareRepository
implements OutputAssembler<StationOutput>,
SearchableRepository {
    private FeatureDao createDao(Session session) {
        return new FeatureDao(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            FeatureDao dao = this.createDao(session);
            boolean bl = dao.hasInstance(this.parseId(id), parameters);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        Session session = this.getSession();
        try {
            FeatureDao stationDao = this.createDao(session);
            DbQuery query = this.addPointLocationOnlyRestriction(this.getDbQuery(parameters));
            List found = stationDao.find(query);
            List<SearchResult> list = this.convertToSearchResults(found, query);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    private List<SearchResult> convertToSearchResults(List<? extends DescribableEntity> found, DbQuery query) {
        String locale = query.getLocale();
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (DescribableEntity describableEntity : found) {
            String pkid = Long.toString(describableEntity.getPkid());
            String label = describableEntity.getLabelFrom(locale);
            results.add((SearchResult)new StationSearchResult(pkid, label));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StationOutput> getAllCondensed(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<StationOutput> list = this.getAllCondensed(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<StationOutput> getAllCondensed(DbQuery parameters, Session session) throws DataAccessException {
        List<FeatureEntity> allFeatures = this.getAllInstances(parameters, session);
        ArrayList<StationOutput> results = new ArrayList<StationOutput>();
        for (FeatureEntity featureEntity : allFeatures) {
            results.add(this.createCondensed(featureEntity, parameters));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StationOutput> getAllExpanded(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<StationOutput> list = this.getAllExpanded(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<StationOutput> getAllExpanded(DbQuery parameters, Session session) throws DataAccessException {
        List<FeatureEntity> allFeatures = this.getAllInstances(parameters, session);
        ArrayList<StationOutput> results = new ArrayList<StationOutput>();
        for (FeatureEntity featureEntity : allFeatures) {
            results.add(this.createExpanded(featureEntity, parameters, session));
        }
        return results;
    }

    private List<FeatureEntity> getAllInstances(DbQuery parameters, Session session) throws DataAccessException {
        FeatureDao featureDao = this.createDao(session);
        return featureDao.getAllInstances(this.addPointLocationOnlyRestriction(parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StationOutput getInstance(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            StationOutput stationOutput = this.getInstance(id, parameters, session);
            return stationOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public StationOutput getInstance(String id, DbQuery parameters, Session session) throws DataAccessException {
        FeatureEntity result = this.getFeatureEntity(id, parameters, session);
        if (result == null) {
            throw new ResourceNotFoundException("Resource with id '" + id + "' could not be found.");
        }
        return this.createExpanded(result, parameters, session);
    }

    private FeatureEntity getFeatureEntity(String id, DbQuery parameters, Session session) throws DataAccessException, BadRequestException {
        DbQuery query = this.addPointLocationOnlyRestriction(parameters);
        return (FeatureEntity)this.createDao(session).getInstance(this.parseId(id), query);
    }

    public StationOutput getCondensedInstance(String id, DbQuery parameters, Session session) throws DataAccessException {
        FeatureDao featureDao = this.createDao(session);
        FeatureEntity result = (FeatureEntity)featureDao.getInstance(this.parseId(id), this.getDbQuery(IoParameters.createDefaults()));
        return this.createCondensed(result, parameters);
    }

    private StationOutput createExpanded(FeatureEntity feature, DbQuery query, Session session) throws DataAccessException {
        IoParameters parameters = query.getParameters();
        StationOutput result = this.createCondensed(feature, query);
        Class<QuantityDatasetEntity> clazz = QuantityDatasetEntity.class;
        DatasetDao<QuantityDatasetEntity> seriesDao = new DatasetDao<QuantityDatasetEntity>(session, clazz);
        List<QuantityDatasetEntity> series = seriesDao.getInstancesWith(feature, query);
        Map<String, DatasetParameters> timeseriesList = this.createTimeseriesList(series, query);
        result.setValue("timeseries", timeseriesList, parameters, arg_0 -> ((StationOutput)result).setTimeseries(arg_0));
        return result;
    }

    private StationOutput createCondensed(FeatureEntity entity, DbQuery query) {
        StationOutput result = new StationOutput();
        IoParameters parameters = query.getParameters();
        String id = Long.toString(entity.getPkid());
        String label = entity.getLabelFrom(query.getLocale());
        Geometry geometry = this.createPoint(entity, query);
        result.setId(id);
        result.setValue("label", (Object)label, parameters, arg_0 -> ((StationOutput)result).setLabel(arg_0));
        result.setValue("geometry", (Object)geometry, parameters, arg_0 -> ((StationOutput)result).setGeometry(arg_0));
        return result;
    }

    private Geometry createPoint(FeatureEntity featureEntity, DbQuery query) {
        return featureEntity.isSetGeometry() ? this.getGeometry(featureEntity.getGeometryEntity(), query) : null;
    }

    private DbQuery addPointLocationOnlyRestriction(DbQuery query) {
        return this.dbQueryFactory.createFrom(query.getParameters().extendWith("geometryTypes", new String[]{"Point"}));
    }
}

