/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.text.TextValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.TextDataEntity;
import org.n52.series.db.beans.TextDatasetEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public class TextDataRepository
extends AbstractDataRepository<TextDatasetEntity, TextDataEntity, TextValue> {
    @Override
    public Class<TextDatasetEntity> getDatasetEntityType() {
        return TextDatasetEntity.class;
    }

    @Override
    protected Data<TextValue> assembleData(TextDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        Data result = new Data();
        DataDao dao = new DataDao(session);
        List observations = dao.getAllInstancesFor(seriesEntity, query);
        for (TextDataEntity observation : observations) {
            if (observation == null) continue;
            result.addValues((AbstractValue[])new TextValue[]{this.createSeriesValueFor(observation, seriesEntity, query)});
        }
        return result;
    }

    @Override
    public TextValue createSeriesValueFor(TextDataEntity observation, TextDatasetEntity series, DbQuery query) {
        ServiceEntity service = this.getServiceEntity(series);
        String observationValue = !service.isNoDataValue(observation) ? (String)observation.getValue() : null;
        TextValue value = this.createValue(observation, series, query, observationValue);
        return this.addMetadatasIfNeeded(observation, value, series, query);
    }

    private TextValue createValue(TextDataEntity observation, TextDatasetEntity series, DbQuery query, String observationValue) {
        ServiceEntity service = this.getServiceEntity(series);
        String textValue = !service.isNoDataValue(observation) ? (String)observation.getValue() : null;
        return this.createValue(textValue, observation, query);
    }

    TextValue createValue(String observationValue, TextDataEntity observation, DbQuery query) {
        Date timeend = observation.getTimeend();
        Date timestart = observation.getTimestart();
        long end = timeend.getTime();
        long start = timestart.getTime();
        IoParameters parameters = query.getParameters();
        return parameters.isShowTimeIntervals() ? new TextValue(Long.valueOf(start), Long.valueOf(end), observationValue) : new TextValue(Long.valueOf(end), observationValue);
    }
}

